// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * This is the disk image base class.
 */
@Fluent
public class SharedGalleryDiskImage implements JsonSerializable<SharedGalleryDiskImage> {
    /*
     * This property indicates the size of the VHD to be created.
     */
    private Integer diskSizeGB;

    /*
     * The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
     */
    private SharedGalleryHostCaching hostCaching;

    /**
     * Creates an instance of SharedGalleryDiskImage class.
     */
    public SharedGalleryDiskImage() {
    }

    /**
     * Get the diskSizeGB property: This property indicates the size of the VHD to be created.
     * 
     * @return the diskSizeGB value.
     */
    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    /**
     * Set the diskSizeGB property: This property indicates the size of the VHD to be created.
     * 
     * @param diskSizeGB the diskSizeGB value to set.
     * @return the SharedGalleryDiskImage object itself.
     */
    SharedGalleryDiskImage withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    /**
     * Get the hostCaching property: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'.
     * 
     * @return the hostCaching value.
     */
    public SharedGalleryHostCaching hostCaching() {
        return this.hostCaching;
    }

    /**
     * Set the hostCaching property: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'.
     * 
     * @param hostCaching the hostCaching value to set.
     * @return the SharedGalleryDiskImage object itself.
     */
    public SharedGalleryDiskImage withHostCaching(SharedGalleryHostCaching hostCaching) {
        this.hostCaching = hostCaching;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostCaching", this.hostCaching == null ? null : this.hostCaching.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharedGalleryDiskImage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharedGalleryDiskImage if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SharedGalleryDiskImage.
     */
    public static SharedGalleryDiskImage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharedGalleryDiskImage deserializedSharedGalleryDiskImage = new SharedGalleryDiskImage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskSizeGB".equals(fieldName)) {
                    deserializedSharedGalleryDiskImage.diskSizeGB = reader.getNullable(JsonReader::getInt);
                } else if ("hostCaching".equals(fieldName)) {
                    deserializedSharedGalleryDiskImage.hostCaching
                        = SharedGalleryHostCaching.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharedGalleryDiskImage;
        });
    }
}
