// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes a set of certificates which are all in the same Key Vault.
 */
@Fluent
public final class VaultSecretGroup implements JsonSerializable<VaultSecretGroup> {
    /*
     * The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     */
    private SubResource sourceVault;

    /*
     * The list of key vault references in SourceVault which contain certificates.
     */
    private List<VaultCertificate> vaultCertificates;

    /**
     * Creates an instance of VaultSecretGroup class.
     */
    public VaultSecretGroup() {
    }

    /**
     * Get the sourceVault property: The relative URL of the Key Vault containing all of the certificates in
     * VaultCertificates.
     * 
     * @return the sourceVault value.
     */
    public SubResource sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set the sourceVault property: The relative URL of the Key Vault containing all of the certificates in
     * VaultCertificates.
     * 
     * @param sourceVault the sourceVault value to set.
     * @return the VaultSecretGroup object itself.
     */
    public VaultSecretGroup withSourceVault(SubResource sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Get the vaultCertificates property: The list of key vault references in SourceVault which contain certificates.
     * 
     * @return the vaultCertificates value.
     */
    public List<VaultCertificate> vaultCertificates() {
        return this.vaultCertificates;
    }

    /**
     * Set the vaultCertificates property: The list of key vault references in SourceVault which contain certificates.
     * 
     * @param vaultCertificates the vaultCertificates value to set.
     * @return the VaultSecretGroup object itself.
     */
    public VaultSecretGroup withVaultCertificates(List<VaultCertificate> vaultCertificates) {
        this.vaultCertificates = vaultCertificates;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vaultCertificates() != null) {
            vaultCertificates().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceVault", this.sourceVault);
        jsonWriter.writeArrayField("vaultCertificates", this.vaultCertificates,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VaultSecretGroup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VaultSecretGroup if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VaultSecretGroup.
     */
    public static VaultSecretGroup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VaultSecretGroup deserializedVaultSecretGroup = new VaultSecretGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceVault".equals(fieldName)) {
                    deserializedVaultSecretGroup.sourceVault = SubResource.fromJson(reader);
                } else if ("vaultCertificates".equals(fieldName)) {
                    List<VaultCertificate> vaultCertificates
                        = reader.readArray(reader1 -> VaultCertificate.fromJson(reader1));
                    deserializedVaultSecretGroup.vaultCertificates = vaultCertificates;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVaultSecretGroup;
        });
    }
}
