// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The instance view of the VM Agent running on the virtual machine.
 */
@Fluent
public final class VirtualMachineAgentInstanceView implements JsonSerializable<VirtualMachineAgentInstanceView> {
    /*
     * The VM Agent full version.
     */
    private String vmAgentVersion;

    /*
     * The virtual machine extension handler instance view.
     */
    private List<VirtualMachineExtensionHandlerInstanceView> extensionHandlers;

    /*
     * The resource status information.
     */
    private List<InstanceViewStatus> statuses;

    /**
     * Creates an instance of VirtualMachineAgentInstanceView class.
     */
    public VirtualMachineAgentInstanceView() {
    }

    /**
     * Get the vmAgentVersion property: The VM Agent full version.
     * 
     * @return the vmAgentVersion value.
     */
    public String vmAgentVersion() {
        return this.vmAgentVersion;
    }

    /**
     * Set the vmAgentVersion property: The VM Agent full version.
     * 
     * @param vmAgentVersion the vmAgentVersion value to set.
     * @return the VirtualMachineAgentInstanceView object itself.
     */
    public VirtualMachineAgentInstanceView withVmAgentVersion(String vmAgentVersion) {
        this.vmAgentVersion = vmAgentVersion;
        return this;
    }

    /**
     * Get the extensionHandlers property: The virtual machine extension handler instance view.
     * 
     * @return the extensionHandlers value.
     */
    public List<VirtualMachineExtensionHandlerInstanceView> extensionHandlers() {
        return this.extensionHandlers;
    }

    /**
     * Set the extensionHandlers property: The virtual machine extension handler instance view.
     * 
     * @param extensionHandlers the extensionHandlers value to set.
     * @return the VirtualMachineAgentInstanceView object itself.
     */
    public VirtualMachineAgentInstanceView
        withExtensionHandlers(List<VirtualMachineExtensionHandlerInstanceView> extensionHandlers) {
        this.extensionHandlers = extensionHandlers;
        return this;
    }

    /**
     * Get the statuses property: The resource status information.
     * 
     * @return the statuses value.
     */
    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    /**
     * Set the statuses property: The resource status information.
     * 
     * @param statuses the statuses value to set.
     * @return the VirtualMachineAgentInstanceView object itself.
     */
    public VirtualMachineAgentInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (extensionHandlers() != null) {
            extensionHandlers().forEach(e -> e.validate());
        }
        if (statuses() != null) {
            statuses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmAgentVersion", this.vmAgentVersion);
        jsonWriter.writeArrayField("extensionHandlers", this.extensionHandlers,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineAgentInstanceView from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineAgentInstanceView if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineAgentInstanceView.
     */
    public static VirtualMachineAgentInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineAgentInstanceView deserializedVirtualMachineAgentInstanceView
                = new VirtualMachineAgentInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vmAgentVersion".equals(fieldName)) {
                    deserializedVirtualMachineAgentInstanceView.vmAgentVersion = reader.getString();
                } else if ("extensionHandlers".equals(fieldName)) {
                    List<VirtualMachineExtensionHandlerInstanceView> extensionHandlers
                        = reader.readArray(reader1 -> VirtualMachineExtensionHandlerInstanceView.fromJson(reader1));
                    deserializedVirtualMachineAgentInstanceView.extensionHandlers = extensionHandlers;
                } else if ("statuses".equals(fieldName)) {
                    List<InstanceViewStatus> statuses
                        = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedVirtualMachineAgentInstanceView.statuses = statuses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineAgentInstanceView;
        });
    }
}
