// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.ComputeOperationValueInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Compute Operation operation response.
 */
@Immutable
public final class ComputeOperationListResult implements JsonSerializable<ComputeOperationListResult> {
    /*
     * The list of compute operations
     */
    private List<ComputeOperationValueInner> value;

    /**
     * Creates an instance of ComputeOperationListResult class.
     */
    public ComputeOperationListResult() {
    }

    /**
     * Get the value property: The list of compute operations.
     * 
     * @return the value value.
     */
    public List<ComputeOperationValueInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ComputeOperationListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ComputeOperationListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ComputeOperationListResult.
     */
    public static ComputeOperationListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ComputeOperationListResult deserializedComputeOperationListResult = new ComputeOperationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ComputeOperationValueInner> value
                        = reader.readArray(reader1 -> ComputeOperationValueInner.fromJson(reader1));
                    deserializedComputeOperationListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedComputeOperationListResult;
        });
    }
}
