// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The List resources which are encrypted with the disk encryption set.
 */
@Fluent
public final class ResourceUriList implements JsonSerializable<ResourceUriList> {
    /*
     * A list of IDs or Owner IDs of resources which are encrypted with the disk encryption set.
     */
    private List<String> value;

    /*
     * The uri to fetch the next page of encrypted resources. Call ListNext() with this to fetch the next page of
     * encrypted resources.
     */
    private String nextLink;

    /**
     * Creates an instance of ResourceUriList class.
     */
    public ResourceUriList() {
    }

    /**
     * Get the value property: A list of IDs or Owner IDs of resources which are encrypted with the disk encryption set.
     * 
     * @return the value value.
     */
    public List<String> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of IDs or Owner IDs of resources which are encrypted with the disk encryption set.
     * 
     * @param value the value value to set.
     * @return the ResourceUriList object itself.
     */
    public ResourceUriList withValue(List<String> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of encrypted resources. Call ListNext() with this to
     * fetch the next page of encrypted resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of encrypted resources. Call ListNext() with this to
     * fetch the next page of encrypted resources.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ResourceUriList object itself.
     */
    public ResourceUriList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model ResourceUriList"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ResourceUriList.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceUriList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceUriList if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResourceUriList.
     */
    public static ResourceUriList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceUriList deserializedResourceUriList = new ResourceUriList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<String> value = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceUriList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedResourceUriList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceUriList;
        });
    }
}
