// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.InstanceSku;
import java.io.IOException;
import java.util.Map;

/**
 * Describes the cloud service role instance.
 */
@Fluent
public final class RoleInstanceInner implements JsonSerializable<RoleInstanceInner> {
    /*
     * Resource Id
     */
    private String id;

    /*
     * Resource Name.
     */
    private String name;

    /*
     * Resource Type.
     */
    private String type;

    /*
     * Resource Location.
     */
    private String location;

    /*
     * Resource tags.
     */
    private Map<String, String> tags;

    /*
     * The role instance SKU.
     */
    private InstanceSku sku;

    /*
     * Role instance properties.
     */
    private RoleInstancePropertiesInner properties;

    /**
     * Creates an instance of RoleInstanceInner class.
     */
    public RoleInstanceInner() {
    }

    /**
     * Get the id property: Resource Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: Resource Name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Resource Type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the location property: Resource Location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Get the sku property: The role instance SKU.
     * 
     * @return the sku value.
     */
    public InstanceSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The role instance SKU.
     * 
     * @param sku the sku value to set.
     * @return the RoleInstanceInner object itself.
     */
    public RoleInstanceInner withSku(InstanceSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the properties property: Role instance properties.
     * 
     * @return the properties value.
     */
    public RoleInstancePropertiesInner properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Role instance properties.
     * 
     * @param properties the properties value to set.
     * @return the RoleInstanceInner object itself.
     */
    public RoleInstanceInner withProperties(RoleInstancePropertiesInner properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleInstanceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleInstanceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleInstanceInner.
     */
    public static RoleInstanceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleInstanceInner deserializedRoleInstanceInner = new RoleInstanceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRoleInstanceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRoleInstanceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRoleInstanceInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedRoleInstanceInner.location = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRoleInstanceInner.tags = tags;
                } else if ("sku".equals(fieldName)) {
                    deserializedRoleInstanceInner.sku = InstanceSku.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedRoleInstanceInner.properties = RoleInstancePropertiesInner.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleInstanceInner;
        });
    }
}
