// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Enables or disables a capability on the virtual machine or virtual machine scale set.
 */
@Fluent
public final class AdditionalCapabilities implements JsonSerializable<AdditionalCapabilities> {
    /*
     * The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage
     * account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual
     * machine or virtual machine scale set only if this property is enabled.
     */
    private Boolean ultraSsdEnabled;

    /*
     * The flag that enables or disables hibernation capability on the VM.
     */
    private Boolean hibernationEnabled;

    /**
     * Creates an instance of AdditionalCapabilities class.
     */
    public AdditionalCapabilities() {
    }

    /**
     * Get the ultraSsdEnabled property: The flag that enables or disables a capability to have one or more managed data
     * disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type
     * UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
     * 
     * @return the ultraSsdEnabled value.
     */
    public Boolean ultraSsdEnabled() {
        return this.ultraSsdEnabled;
    }

    /**
     * Set the ultraSsdEnabled property: The flag that enables or disables a capability to have one or more managed data
     * disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type
     * UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
     * 
     * @param ultraSsdEnabled the ultraSsdEnabled value to set.
     * @return the AdditionalCapabilities object itself.
     */
    public AdditionalCapabilities withUltraSsdEnabled(Boolean ultraSsdEnabled) {
        this.ultraSsdEnabled = ultraSsdEnabled;
        return this;
    }

    /**
     * Get the hibernationEnabled property: The flag that enables or disables hibernation capability on the VM.
     * 
     * @return the hibernationEnabled value.
     */
    public Boolean hibernationEnabled() {
        return this.hibernationEnabled;
    }

    /**
     * Set the hibernationEnabled property: The flag that enables or disables hibernation capability on the VM.
     * 
     * @param hibernationEnabled the hibernationEnabled value to set.
     * @return the AdditionalCapabilities object itself.
     */
    public AdditionalCapabilities withHibernationEnabled(Boolean hibernationEnabled) {
        this.hibernationEnabled = hibernationEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("ultraSSDEnabled", this.ultraSsdEnabled);
        jsonWriter.writeBooleanField("hibernationEnabled", this.hibernationEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AdditionalCapabilities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AdditionalCapabilities if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AdditionalCapabilities.
     */
    public static AdditionalCapabilities fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AdditionalCapabilities deserializedAdditionalCapabilities = new AdditionalCapabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ultraSSDEnabled".equals(fieldName)) {
                    deserializedAdditionalCapabilities.ultraSsdEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("hibernationEnabled".equals(fieldName)) {
                    deserializedAdditionalCapabilities.hibernationEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAdditionalCapabilities;
        });
    }
}
