// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the Virtual Machine Scale Set to convert from Availability Set.
 */
@Fluent
public final class ConvertToVirtualMachineScaleSetInput
    implements JsonSerializable<ConvertToVirtualMachineScaleSetInput> {
    /*
     * Specifies information about the Virtual Machine Scale Set that the Availability Set should be converted to.
     */
    private String virtualMachineScaleSetName;

    /**
     * Creates an instance of ConvertToVirtualMachineScaleSetInput class.
     */
    public ConvertToVirtualMachineScaleSetInput() {
    }

    /**
     * Get the virtualMachineScaleSetName property: Specifies information about the Virtual Machine Scale Set that the
     * Availability Set should be converted to.
     * 
     * @return the virtualMachineScaleSetName value.
     */
    public String virtualMachineScaleSetName() {
        return this.virtualMachineScaleSetName;
    }

    /**
     * Set the virtualMachineScaleSetName property: Specifies information about the Virtual Machine Scale Set that the
     * Availability Set should be converted to.
     * 
     * @param virtualMachineScaleSetName the virtualMachineScaleSetName value to set.
     * @return the ConvertToVirtualMachineScaleSetInput object itself.
     */
    public ConvertToVirtualMachineScaleSetInput withVirtualMachineScaleSetName(String virtualMachineScaleSetName) {
        this.virtualMachineScaleSetName = virtualMachineScaleSetName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("virtualMachineScaleSetName", this.virtualMachineScaleSetName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConvertToVirtualMachineScaleSetInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConvertToVirtualMachineScaleSetInput if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConvertToVirtualMachineScaleSetInput.
     */
    public static ConvertToVirtualMachineScaleSetInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConvertToVirtualMachineScaleSetInput deserializedConvertToVirtualMachineScaleSetInput
                = new ConvertToVirtualMachineScaleSetInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualMachineScaleSetName".equals(fieldName)) {
                    deserializedConvertToVirtualMachineScaleSetInput.virtualMachineScaleSetName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConvertToVirtualMachineScaleSetInput;
        });
    }
}
