// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The instance view of a dedicated host that includes the name of the dedicated host. It is used for the response to
 * the instance view of a dedicated host group.
 */
@Fluent
public final class DedicatedHostInstanceViewWithName extends DedicatedHostInstanceView {
    /*
     * The name of the dedicated host.
     */
    private String name;

    /*
     * Specifies the unique id of the dedicated physical machine on which the dedicated host resides.
     */
    private String assetId;

    /**
     * Creates an instance of DedicatedHostInstanceViewWithName class.
     */
    public DedicatedHostInstanceViewWithName() {
    }

    /**
     * Get the name property: The name of the dedicated host.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the assetId property: Specifies the unique id of the dedicated physical machine on which the dedicated host
     * resides.
     * 
     * @return the assetId value.
     */
    @Override
    public String assetId() {
        return this.assetId;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DedicatedHostInstanceViewWithName withAvailableCapacity(DedicatedHostAvailableCapacity availableCapacity) {
        super.withAvailableCapacity(availableCapacity);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DedicatedHostInstanceViewWithName withStatuses(List<InstanceViewStatus> statuses) {
        super.withStatuses(statuses);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (availableCapacity() != null) {
            availableCapacity().validate();
        }
        if (statuses() != null) {
            statuses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("availableCapacity", availableCapacity());
        jsonWriter.writeArrayField("statuses", statuses(), (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DedicatedHostInstanceViewWithName from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DedicatedHostInstanceViewWithName if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DedicatedHostInstanceViewWithName.
     */
    public static DedicatedHostInstanceViewWithName fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostInstanceViewWithName deserializedDedicatedHostInstanceViewWithName
                = new DedicatedHostInstanceViewWithName();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("assetId".equals(fieldName)) {
                    deserializedDedicatedHostInstanceViewWithName.assetId = reader.getString();
                } else if ("availableCapacity".equals(fieldName)) {
                    deserializedDedicatedHostInstanceViewWithName
                        .withAvailableCapacity(DedicatedHostAvailableCapacity.fromJson(reader));
                } else if ("statuses".equals(fieldName)) {
                    List<InstanceViewStatus> statuses
                        = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedDedicatedHostInstanceViewWithName.withStatuses(statuses);
                } else if ("name".equals(fieldName)) {
                    deserializedDedicatedHostInstanceViewWithName.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDedicatedHostInstanceViewWithName;
        });
    }
}
