// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The instance view of a disk restore point.
 */
@Fluent
public final class DiskRestorePointInstanceView implements JsonSerializable<DiskRestorePointInstanceView> {
    /*
     * Disk restore point Id.
     */
    private String id;

    /*
     * The disk restore point replication status information.
     */
    private DiskRestorePointReplicationStatus replicationStatus;

    /**
     * Creates an instance of DiskRestorePointInstanceView class.
     */
    public DiskRestorePointInstanceView() {
    }

    /**
     * Get the id property: Disk restore point Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Disk restore point Id.
     * 
     * @param id the id value to set.
     * @return the DiskRestorePointInstanceView object itself.
     */
    public DiskRestorePointInstanceView withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the replicationStatus property: The disk restore point replication status information.
     * 
     * @return the replicationStatus value.
     */
    public DiskRestorePointReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    /**
     * Set the replicationStatus property: The disk restore point replication status information.
     * 
     * @param replicationStatus the replicationStatus value to set.
     * @return the DiskRestorePointInstanceView object itself.
     */
    public DiskRestorePointInstanceView withReplicationStatus(DiskRestorePointReplicationStatus replicationStatus) {
        this.replicationStatus = replicationStatus;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (replicationStatus() != null) {
            replicationStatus().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("replicationStatus", this.replicationStatus);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskRestorePointInstanceView from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskRestorePointInstanceView if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskRestorePointInstanceView.
     */
    public static DiskRestorePointInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskRestorePointInstanceView deserializedDiskRestorePointInstanceView = new DiskRestorePointInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDiskRestorePointInstanceView.id = reader.getString();
                } else if ("replicationStatus".equals(fieldName)) {
                    deserializedDiskRestorePointInstanceView.replicationStatus
                        = DiskRestorePointReplicationStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskRestorePointInstanceView;
        });
    }
}
