// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
 */
@Fluent
public final class EncryptionImages implements JsonSerializable<EncryptionImages> {
    /*
     * Contains encryption settings for an OS disk image.
     */
    private OSDiskImageEncryption osDiskImage;

    /*
     * A list of encryption specifications for data disk images.
     */
    private List<DataDiskImageEncryption> dataDiskImages;

    /**
     * Creates an instance of EncryptionImages class.
     */
    public EncryptionImages() {
    }

    /**
     * Get the osDiskImage property: Contains encryption settings for an OS disk image.
     * 
     * @return the osDiskImage value.
     */
    public OSDiskImageEncryption osDiskImage() {
        return this.osDiskImage;
    }

    /**
     * Set the osDiskImage property: Contains encryption settings for an OS disk image.
     * 
     * @param osDiskImage the osDiskImage value to set.
     * @return the EncryptionImages object itself.
     */
    public EncryptionImages withOsDiskImage(OSDiskImageEncryption osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    /**
     * Get the dataDiskImages property: A list of encryption specifications for data disk images.
     * 
     * @return the dataDiskImages value.
     */
    public List<DataDiskImageEncryption> dataDiskImages() {
        return this.dataDiskImages;
    }

    /**
     * Set the dataDiskImages property: A list of encryption specifications for data disk images.
     * 
     * @param dataDiskImages the dataDiskImages value to set.
     * @return the EncryptionImages object itself.
     */
    public EncryptionImages withDataDiskImages(List<DataDiskImageEncryption> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (osDiskImage() != null) {
            osDiskImage().validate();
        }
        if (dataDiskImages() != null) {
            dataDiskImages().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("osDiskImage", this.osDiskImage);
        jsonWriter.writeArrayField("dataDiskImages", this.dataDiskImages,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionImages from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionImages if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionImages.
     */
    public static EncryptionImages fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionImages deserializedEncryptionImages = new EncryptionImages();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("osDiskImage".equals(fieldName)) {
                    deserializedEncryptionImages.osDiskImage = OSDiskImageEncryption.fromJson(reader);
                } else if ("dataDiskImages".equals(fieldName)) {
                    List<DataDiskImageEncryption> dataDiskImages
                        = reader.readArray(reader1 -> DataDiskImageEncryption.fromJson(reader1));
                    deserializedEncryptionImages.dataDiskImages = dataDiskImages;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionImages;
        });
    }
}
