// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of a gallery ResourceProfile.
 */
@Immutable
public class GalleryResourceProfilePropertiesBase implements JsonSerializable<GalleryResourceProfilePropertiesBase> {
    /*
     * The provisioning state, which only appears in the response.
     */
    private GalleryProvisioningState provisioningState;

    /**
     * Creates an instance of GalleryResourceProfilePropertiesBase class.
     */
    public GalleryResourceProfilePropertiesBase() {
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the GalleryResourceProfilePropertiesBase object itself.
     */
    GalleryResourceProfilePropertiesBase withProvisioningState(GalleryProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryResourceProfilePropertiesBase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryResourceProfilePropertiesBase if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryResourceProfilePropertiesBase.
     */
    public static GalleryResourceProfilePropertiesBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryResourceProfilePropertiesBase deserializedGalleryResourceProfilePropertiesBase
                = new GalleryResourceProfilePropertiesBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryResourceProfilePropertiesBase.provisioningState
                        = GalleryProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryResourceProfilePropertiesBase;
        });
    }
}
