// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the execution mode. In Audit mode, the system acts as if it is enforcing the access control policy,
 * including emitting access denial entries in the logs but it does not actually deny any requests to host endpoints. In
 * Enforce mode, the system will enforce the access control and it is the recommended mode of operation.
 */
public final class Modes extends ExpandableStringEnum<Modes> {
    /**
     * Static value Audit for Modes.
     */
    public static final Modes AUDIT = fromString("Audit");

    /**
     * Static value Enforce for Modes.
     */
    public static final Modes ENFORCE = fromString("Enforce");

    /**
     * Static value Disabled for Modes.
     */
    public static final Modes DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of Modes value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Modes() {
    }

    /**
     * Creates or finds a Modes from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding Modes.
     */
    public static Modes fromString(String name) {
        return fromString(name, Modes.class);
    }

    /**
     * Gets known Modes values.
     * 
     * @return known Modes values.
     */
    public static Collection<Modes> values() {
        return values(Modes.class);
    }
}
