// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of rebalance strategy that will be used for rebalancing virtual machines in the scale set across availability
 * zones. Default and only supported value for now is Recreate.
 */
public final class RebalanceStrategy extends ExpandableStringEnum<RebalanceStrategy> {
    /**
     * Static value Recreate for RebalanceStrategy.
     */
    public static final RebalanceStrategy RECREATE = fromString("Recreate");

    /**
     * Creates a new instance of RebalanceStrategy value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RebalanceStrategy() {
    }

    /**
     * Creates or finds a RebalanceStrategy from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RebalanceStrategy.
     */
    public static RebalanceStrategy fromString(String name) {
        return fromString(name, RebalanceStrategy.class);
    }

    /**
     * Gets known RebalanceStrategy values.
     * 
     * @return known RebalanceStrategy values.
     */
    public static Collection<RebalanceStrategy> values() {
        return values(RebalanceStrategy.class);
    }
}
