// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.RunCommandDocumentBaseInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Virtual Machine operation response.
 */
@Fluent
public final class RunCommandListResult implements JsonSerializable<RunCommandListResult> {
    /*
     * The list of virtual machine run commands.
     */
    private List<RunCommandDocumentBaseInner> value;

    /*
     * The uri to fetch the next page of run commands. Call ListNext() with this to fetch the next page of run commands.
     */
    private String nextLink;

    /**
     * Creates an instance of RunCommandListResult class.
     */
    public RunCommandListResult() {
    }

    /**
     * Get the value property: The list of virtual machine run commands.
     * 
     * @return the value value.
     */
    public List<RunCommandDocumentBaseInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of virtual machine run commands.
     * 
     * @param value the value value to set.
     * @return the RunCommandListResult object itself.
     */
    public RunCommandListResult withValue(List<RunCommandDocumentBaseInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of run commands. Call ListNext() with this to fetch the
     * next page of run commands.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of run commands. Call ListNext() with this to fetch the
     * next page of run commands.
     * 
     * @param nextLink the nextLink value to set.
     * @return the RunCommandListResult object itself.
     */
    public RunCommandListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model RunCommandListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RunCommandListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunCommandListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunCommandListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunCommandListResult.
     */
    public static RunCommandListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunCommandListResult deserializedRunCommandListResult = new RunCommandListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RunCommandDocumentBaseInner> value
                        = reader.readArray(reader1 -> RunCommandDocumentBaseInner.fromJson(reader1));
                    deserializedRunCommandListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRunCommandListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunCommandListResult;
        });
    }
}
