// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ScheduledEventsProfile model.
 */
@Fluent
public final class ScheduledEventsProfile implements JsonSerializable<ScheduledEventsProfile> {
    /*
     * Specifies Terminate Scheduled Event related configurations.
     */
    private TerminateNotificationProfile terminateNotificationProfile;

    /*
     * Specifies OS Image Scheduled Event related configurations.
     */
    private OSImageNotificationProfile osImageNotificationProfile;

    /**
     * Creates an instance of ScheduledEventsProfile class.
     */
    public ScheduledEventsProfile() {
    }

    /**
     * Get the terminateNotificationProfile property: Specifies Terminate Scheduled Event related configurations.
     * 
     * @return the terminateNotificationProfile value.
     */
    public TerminateNotificationProfile terminateNotificationProfile() {
        return this.terminateNotificationProfile;
    }

    /**
     * Set the terminateNotificationProfile property: Specifies Terminate Scheduled Event related configurations.
     * 
     * @param terminateNotificationProfile the terminateNotificationProfile value to set.
     * @return the ScheduledEventsProfile object itself.
     */
    public ScheduledEventsProfile
        withTerminateNotificationProfile(TerminateNotificationProfile terminateNotificationProfile) {
        this.terminateNotificationProfile = terminateNotificationProfile;
        return this;
    }

    /**
     * Get the osImageNotificationProfile property: Specifies OS Image Scheduled Event related configurations.
     * 
     * @return the osImageNotificationProfile value.
     */
    public OSImageNotificationProfile osImageNotificationProfile() {
        return this.osImageNotificationProfile;
    }

    /**
     * Set the osImageNotificationProfile property: Specifies OS Image Scheduled Event related configurations.
     * 
     * @param osImageNotificationProfile the osImageNotificationProfile value to set.
     * @return the ScheduledEventsProfile object itself.
     */
    public ScheduledEventsProfile
        withOsImageNotificationProfile(OSImageNotificationProfile osImageNotificationProfile) {
        this.osImageNotificationProfile = osImageNotificationProfile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (terminateNotificationProfile() != null) {
            terminateNotificationProfile().validate();
        }
        if (osImageNotificationProfile() != null) {
            osImageNotificationProfile().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("terminateNotificationProfile", this.terminateNotificationProfile);
        jsonWriter.writeJsonField("osImageNotificationProfile", this.osImageNotificationProfile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScheduledEventsProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScheduledEventsProfile if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScheduledEventsProfile.
     */
    public static ScheduledEventsProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScheduledEventsProfile deserializedScheduledEventsProfile = new ScheduledEventsProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("terminateNotificationProfile".equals(fieldName)) {
                    deserializedScheduledEventsProfile.terminateNotificationProfile
                        = TerminateNotificationProfile.fromJson(reader);
                } else if ("osImageNotificationProfile".equals(fieldName)) {
                    deserializedScheduledEventsProfile.osImageNotificationProfile
                        = OSImageNotificationProfile.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScheduledEventsProfile;
        });
    }
}
