// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * This property allows you to specify the type of sharing group. Possible values are: **Subscriptions,**
 * **AADTenants.**.
 */
public final class SharingProfileGroupTypes extends ExpandableStringEnum<SharingProfileGroupTypes> {
    /**
     * Static value Subscriptions for SharingProfileGroupTypes.
     */
    public static final SharingProfileGroupTypes SUBSCRIPTIONS = fromString("Subscriptions");

    /**
     * Static value AADTenants for SharingProfileGroupTypes.
     */
    public static final SharingProfileGroupTypes AADTENANTS = fromString("AADTenants");

    /**
     * Creates a new instance of SharingProfileGroupTypes value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SharingProfileGroupTypes() {
    }

    /**
     * Creates or finds a SharingProfileGroupTypes from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SharingProfileGroupTypes.
     */
    public static SharingProfileGroupTypes fromString(String name) {
        return fromString(name, SharingProfileGroupTypes.class);
    }

    /**
     * Gets known SharingProfileGroupTypes values.
     * 
     * @return known SharingProfileGroupTypes values.
     */
    public static Collection<SharingProfileGroupTypes> values() {
        return values(SharingProfileGroupTypes.class);
    }
}
