// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The encryption type of the SSH keys to be generated. See SshEncryptionTypes for possible set of values. If not
 * provided, will default to RSA.
 */
public final class SshEncryptionTypes extends ExpandableStringEnum<SshEncryptionTypes> {
    /**
     * Static value RSA for SshEncryptionTypes.
     */
    public static final SshEncryptionTypes RSA = fromString("RSA");

    /**
     * Static value Ed25519 for SshEncryptionTypes.
     */
    public static final SshEncryptionTypes ED25519 = fromString("Ed25519");

    /**
     * Creates a new instance of SshEncryptionTypes value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SshEncryptionTypes() {
    }

    /**
     * Creates or finds a SshEncryptionTypes from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SshEncryptionTypes.
     */
    public static SshEncryptionTypes fromString(String name) {
        return fromString(name, SshEncryptionTypes.class);
    }

    /**
     * Gets known SshEncryptionTypes values.
     * 
     * @return known SshEncryptionTypes values.
     */
    public static Collection<SshEncryptionTypes> values() {
        return values(SshEncryptionTypes.class);
    }
}
