// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

/**
 * Code indicating the current status of the upgrade.
 */
public enum UpgradeState {
    /**
     * Enum value RollingForward.
     */
    ROLLING_FORWARD("RollingForward"),

    /**
     * Enum value Cancelled.
     */
    CANCELLED("Cancelled"),

    /**
     * Enum value Completed.
     */
    COMPLETED("Completed"),

    /**
     * Enum value Faulted.
     */
    FAULTED("Faulted");

    /**
     * The actual serialized value for a UpgradeState instance.
     */
    private final String value;

    UpgradeState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a UpgradeState instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed UpgradeState object, or null if unable to parse.
     */
    public static UpgradeState fromString(String value) {
        if (value == null) {
            return null;
        }
        UpgradeState[] items = UpgradeState.values();
        for (UpgradeState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
