// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The source image from which the Image Version is going to be created.
 */
@Fluent
public final class UserArtifactSource implements JsonSerializable<UserArtifactSource> {
    /*
     * Required. The mediaLink of the artifact, must be a readable storage page blob.
     */
    private String mediaLink;

    /*
     * Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
     */
    private String defaultConfigurationLink;

    /**
     * Creates an instance of UserArtifactSource class.
     */
    public UserArtifactSource() {
    }

    /**
     * Get the mediaLink property: Required. The mediaLink of the artifact, must be a readable storage page blob.
     * 
     * @return the mediaLink value.
     */
    public String mediaLink() {
        return this.mediaLink;
    }

    /**
     * Set the mediaLink property: Required. The mediaLink of the artifact, must be a readable storage page blob.
     * 
     * @param mediaLink the mediaLink value to set.
     * @return the UserArtifactSource object itself.
     */
    public UserArtifactSource withMediaLink(String mediaLink) {
        this.mediaLink = mediaLink;
        return this;
    }

    /**
     * Get the defaultConfigurationLink property: Optional. The defaultConfigurationLink of the artifact, must be a
     * readable storage page blob.
     * 
     * @return the defaultConfigurationLink value.
     */
    public String defaultConfigurationLink() {
        return this.defaultConfigurationLink;
    }

    /**
     * Set the defaultConfigurationLink property: Optional. The defaultConfigurationLink of the artifact, must be a
     * readable storage page blob.
     * 
     * @param defaultConfigurationLink the defaultConfigurationLink value to set.
     * @return the UserArtifactSource object itself.
     */
    public UserArtifactSource withDefaultConfigurationLink(String defaultConfigurationLink) {
        this.defaultConfigurationLink = defaultConfigurationLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mediaLink() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property mediaLink in model UserArtifactSource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UserArtifactSource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mediaLink", this.mediaLink);
        jsonWriter.writeStringField("defaultConfigurationLink", this.defaultConfigurationLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserArtifactSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserArtifactSource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UserArtifactSource.
     */
    public static UserArtifactSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserArtifactSource deserializedUserArtifactSource = new UserArtifactSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mediaLink".equals(fieldName)) {
                    deserializedUserArtifactSource.mediaLink = reader.getString();
                } else if ("defaultConfigurationLink".equals(fieldName)) {
                    deserializedUserArtifactSource.defaultConfigurationLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserArtifactSource;
        });
    }
}
