// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains the IP tag associated with the public IP address.
 */
@Fluent
public final class VirtualMachineScaleSetIpTag implements JsonSerializable<VirtualMachineScaleSetIpTag> {
    /*
     * IP tag type. Example: FirstPartyUsage.
     */
    private String ipTagType;

    /*
     * IP tag associated with the public IP. Example: SQL, Storage etc.
     */
    private String tag;

    /**
     * Creates an instance of VirtualMachineScaleSetIpTag class.
     */
    public VirtualMachineScaleSetIpTag() {
    }

    /**
     * Get the ipTagType property: IP tag type. Example: FirstPartyUsage.
     * 
     * @return the ipTagType value.
     */
    public String ipTagType() {
        return this.ipTagType;
    }

    /**
     * Set the ipTagType property: IP tag type. Example: FirstPartyUsage.
     * 
     * @param ipTagType the ipTagType value to set.
     * @return the VirtualMachineScaleSetIpTag object itself.
     */
    public VirtualMachineScaleSetIpTag withIpTagType(String ipTagType) {
        this.ipTagType = ipTagType;
        return this;
    }

    /**
     * Get the tag property: IP tag associated with the public IP. Example: SQL, Storage etc.
     * 
     * @return the tag value.
     */
    public String tag() {
        return this.tag;
    }

    /**
     * Set the tag property: IP tag associated with the public IP. Example: SQL, Storage etc.
     * 
     * @param tag the tag value to set.
     * @return the VirtualMachineScaleSetIpTag object itself.
     */
    public VirtualMachineScaleSetIpTag withTag(String tag) {
        this.tag = tag;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipTagType", this.ipTagType);
        jsonWriter.writeStringField("tag", this.tag);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetIpTag from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetIpTag if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetIpTag.
     */
    public static VirtualMachineScaleSetIpTag fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetIpTag deserializedVirtualMachineScaleSetIpTag = new VirtualMachineScaleSetIpTag();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipTagType".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetIpTag.ipTagType = reader.getString();
                } else if ("tag".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetIpTag.tag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetIpTag;
        });
    }
}
