/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.RunCommandInputParameter;
import com.azure.resourcemanager.compute.models.RunCommandManagedIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandInstanceView;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandScriptSource;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineRunCommandProperties
implements JsonSerializable<VirtualMachineRunCommandProperties> {
    private VirtualMachineRunCommandScriptSource source;
    private List<RunCommandInputParameter> parameters;
    private List<RunCommandInputParameter> protectedParameters;
    private Boolean asyncExecution;
    private String runAsUser;
    private String runAsPassword;
    private Integer timeoutInSeconds;
    private String outputBlobUri;
    private String errorBlobUri;
    private RunCommandManagedIdentity outputBlobManagedIdentity;
    private RunCommandManagedIdentity errorBlobManagedIdentity;
    private String provisioningState;
    private VirtualMachineRunCommandInstanceView instanceView;
    private Boolean treatFailureAsDeploymentFailure;

    public VirtualMachineRunCommandScriptSource source() {
        return this.source;
    }

    public VirtualMachineRunCommandProperties withSource(VirtualMachineRunCommandScriptSource source) {
        this.source = source;
        return this;
    }

    public List<RunCommandInputParameter> parameters() {
        return this.parameters;
    }

    public VirtualMachineRunCommandProperties withParameters(List<RunCommandInputParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<RunCommandInputParameter> protectedParameters() {
        return this.protectedParameters;
    }

    public VirtualMachineRunCommandProperties withProtectedParameters(List<RunCommandInputParameter> protectedParameters) {
        this.protectedParameters = protectedParameters;
        return this;
    }

    public Boolean asyncExecution() {
        return this.asyncExecution;
    }

    public VirtualMachineRunCommandProperties withAsyncExecution(Boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
        return this;
    }

    public String runAsUser() {
        return this.runAsUser;
    }

    public VirtualMachineRunCommandProperties withRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    public String runAsPassword() {
        return this.runAsPassword;
    }

    public VirtualMachineRunCommandProperties withRunAsPassword(String runAsPassword) {
        this.runAsPassword = runAsPassword;
        return this;
    }

    public Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public VirtualMachineRunCommandProperties withTimeoutInSeconds(Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
        return this;
    }

    public String outputBlobUri() {
        return this.outputBlobUri;
    }

    public VirtualMachineRunCommandProperties withOutputBlobUri(String outputBlobUri) {
        this.outputBlobUri = outputBlobUri;
        return this;
    }

    public String errorBlobUri() {
        return this.errorBlobUri;
    }

    public VirtualMachineRunCommandProperties withErrorBlobUri(String errorBlobUri) {
        this.errorBlobUri = errorBlobUri;
        return this;
    }

    public RunCommandManagedIdentity outputBlobManagedIdentity() {
        return this.outputBlobManagedIdentity;
    }

    public VirtualMachineRunCommandProperties withOutputBlobManagedIdentity(RunCommandManagedIdentity outputBlobManagedIdentity) {
        this.outputBlobManagedIdentity = outputBlobManagedIdentity;
        return this;
    }

    public RunCommandManagedIdentity errorBlobManagedIdentity() {
        return this.errorBlobManagedIdentity;
    }

    public VirtualMachineRunCommandProperties withErrorBlobManagedIdentity(RunCommandManagedIdentity errorBlobManagedIdentity) {
        this.errorBlobManagedIdentity = errorBlobManagedIdentity;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public VirtualMachineRunCommandInstanceView instanceView() {
        return this.instanceView;
    }

    public Boolean treatFailureAsDeploymentFailure() {
        return this.treatFailureAsDeploymentFailure;
    }

    public VirtualMachineRunCommandProperties withTreatFailureAsDeploymentFailure(Boolean treatFailureAsDeploymentFailure) {
        this.treatFailureAsDeploymentFailure = treatFailureAsDeploymentFailure;
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
        if (this.protectedParameters() != null) {
            this.protectedParameters().forEach(e -> e.validate());
        }
        if (this.outputBlobManagedIdentity() != null) {
            this.outputBlobManagedIdentity().validate();
        }
        if (this.errorBlobManagedIdentity() != null) {
            this.errorBlobManagedIdentity().validate();
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("protectedParameters", this.protectedParameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("asyncExecution", this.asyncExecution);
        jsonWriter.writeStringField("runAsUser", this.runAsUser);
        jsonWriter.writeStringField("runAsPassword", this.runAsPassword);
        jsonWriter.writeNumberField("timeoutInSeconds", (Number)this.timeoutInSeconds);
        jsonWriter.writeStringField("outputBlobUri", this.outputBlobUri);
        jsonWriter.writeStringField("errorBlobUri", this.errorBlobUri);
        jsonWriter.writeJsonField("outputBlobManagedIdentity", (JsonSerializable)this.outputBlobManagedIdentity);
        jsonWriter.writeJsonField("errorBlobManagedIdentity", (JsonSerializable)this.errorBlobManagedIdentity);
        jsonWriter.writeBooleanField("treatFailureAsDeploymentFailure", this.treatFailureAsDeploymentFailure);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineRunCommandProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineRunCommandProperties)jsonReader.readObject(reader -> {
            VirtualMachineRunCommandProperties deserializedVirtualMachineRunCommandProperties = new VirtualMachineRunCommandProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.source = VirtualMachineRunCommandScriptSource.fromJson(reader);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedVirtualMachineRunCommandProperties.parameters = parameters = reader.readArray(reader1 -> RunCommandInputParameter.fromJson(reader1));
                    continue;
                }
                if ("protectedParameters".equals(fieldName)) {
                    List protectedParameters;
                    deserializedVirtualMachineRunCommandProperties.protectedParameters = protectedParameters = reader.readArray(reader1 -> RunCommandInputParameter.fromJson(reader1));
                    continue;
                }
                if ("asyncExecution".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.asyncExecution = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("runAsUser".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.runAsUser = reader.getString();
                    continue;
                }
                if ("runAsPassword".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.runAsPassword = reader.getString();
                    continue;
                }
                if ("timeoutInSeconds".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.timeoutInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("outputBlobUri".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.outputBlobUri = reader.getString();
                    continue;
                }
                if ("errorBlobUri".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.errorBlobUri = reader.getString();
                    continue;
                }
                if ("outputBlobManagedIdentity".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.outputBlobManagedIdentity = RunCommandManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("errorBlobManagedIdentity".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.errorBlobManagedIdentity = RunCommandManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.instanceView = VirtualMachineRunCommandInstanceView.fromJson(reader);
                    continue;
                }
                if ("treatFailureAsDeploymentFailure".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandProperties.treatFailureAsDeploymentFailure = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineRunCommandProperties;
        });
    }
}

