/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.DiskAccessInner;
import java.io.IOException;
import java.util.List;

public final class DiskAccessList
implements JsonSerializable<DiskAccessList> {
    private List<DiskAccessInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DiskAccessList.class);

    public List<DiskAccessInner> value() {
        return this.value;
    }

    public DiskAccessList withValue(List<DiskAccessInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public DiskAccessList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DiskAccessList"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static DiskAccessList fromJson(JsonReader jsonReader) throws IOException {
        return (DiskAccessList)jsonReader.readObject(reader -> {
            DiskAccessList deserializedDiskAccessList = new DiskAccessList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDiskAccessList.value = value = reader.readArray(reader1 -> DiskAccessInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDiskAccessList.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskAccessList;
        });
    }
}

