/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.LinuxPatchAssessmentMode;
import com.azure.resourcemanager.compute.models.LinuxVMGuestPatchAutomaticByPlatformSettings;
import com.azure.resourcemanager.compute.models.LinuxVMGuestPatchMode;
import java.io.IOException;

public final class LinuxPatchSettings
implements JsonSerializable<LinuxPatchSettings> {
    private LinuxVMGuestPatchMode patchMode;
    private LinuxPatchAssessmentMode assessmentMode;
    private LinuxVMGuestPatchAutomaticByPlatformSettings automaticByPlatformSettings;

    public LinuxVMGuestPatchMode patchMode() {
        return this.patchMode;
    }

    public LinuxPatchSettings withPatchMode(LinuxVMGuestPatchMode patchMode) {
        this.patchMode = patchMode;
        return this;
    }

    public LinuxPatchAssessmentMode assessmentMode() {
        return this.assessmentMode;
    }

    public LinuxPatchSettings withAssessmentMode(LinuxPatchAssessmentMode assessmentMode) {
        this.assessmentMode = assessmentMode;
        return this;
    }

    public LinuxVMGuestPatchAutomaticByPlatformSettings automaticByPlatformSettings() {
        return this.automaticByPlatformSettings;
    }

    public LinuxPatchSettings withAutomaticByPlatformSettings(LinuxVMGuestPatchAutomaticByPlatformSettings automaticByPlatformSettings) {
        this.automaticByPlatformSettings = automaticByPlatformSettings;
        return this;
    }

    public void validate() {
        if (this.automaticByPlatformSettings() != null) {
            this.automaticByPlatformSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("patchMode", this.patchMode == null ? null : this.patchMode.toString());
        jsonWriter.writeStringField("assessmentMode", this.assessmentMode == null ? null : this.assessmentMode.toString());
        jsonWriter.writeJsonField("automaticByPlatformSettings", (JsonSerializable)this.automaticByPlatformSettings);
        return jsonWriter.writeEndObject();
    }

    public static LinuxPatchSettings fromJson(JsonReader jsonReader) throws IOException {
        return (LinuxPatchSettings)jsonReader.readObject(reader -> {
            LinuxPatchSettings deserializedLinuxPatchSettings = new LinuxPatchSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("patchMode".equals(fieldName)) {
                    deserializedLinuxPatchSettings.patchMode = LinuxVMGuestPatchMode.fromString(reader.getString());
                    continue;
                }
                if ("assessmentMode".equals(fieldName)) {
                    deserializedLinuxPatchSettings.assessmentMode = LinuxPatchAssessmentMode.fromString(reader.getString());
                    continue;
                }
                if ("automaticByPlatformSettings".equals(fieldName)) {
                    deserializedLinuxPatchSettings.automaticByPlatformSettings = LinuxVMGuestPatchAutomaticByPlatformSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinuxPatchSettings;
        });
    }
}

