// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.SoftDeletedArtifactTypes;
import java.io.IOException;

/**
 * Describes the properties of a soft-deleted resource.
 */
@Fluent
public final class GallerySoftDeletedResourceProperties
    implements JsonSerializable<GallerySoftDeletedResourceProperties> {
    /*
     * arm id of the soft-deleted resource
     */
    private String resourceArmId;

    /*
     * artifact type of the soft-deleted resource
     */
    private SoftDeletedArtifactTypes softDeletedArtifactType;

    /*
     * The timestamp for when the resource is soft-deleted. In dateTime offset format.
     */
    private String softDeletedTime;

    /**
     * Creates an instance of GallerySoftDeletedResourceProperties class.
     */
    public GallerySoftDeletedResourceProperties() {
    }

    /**
     * Get the resourceArmId property: arm id of the soft-deleted resource.
     * 
     * @return the resourceArmId value.
     */
    public String resourceArmId() {
        return this.resourceArmId;
    }

    /**
     * Set the resourceArmId property: arm id of the soft-deleted resource.
     * 
     * @param resourceArmId the resourceArmId value to set.
     * @return the GallerySoftDeletedResourceProperties object itself.
     */
    public GallerySoftDeletedResourceProperties withResourceArmId(String resourceArmId) {
        this.resourceArmId = resourceArmId;
        return this;
    }

    /**
     * Get the softDeletedArtifactType property: artifact type of the soft-deleted resource.
     * 
     * @return the softDeletedArtifactType value.
     */
    public SoftDeletedArtifactTypes softDeletedArtifactType() {
        return this.softDeletedArtifactType;
    }

    /**
     * Set the softDeletedArtifactType property: artifact type of the soft-deleted resource.
     * 
     * @param softDeletedArtifactType the softDeletedArtifactType value to set.
     * @return the GallerySoftDeletedResourceProperties object itself.
     */
    public GallerySoftDeletedResourceProperties
        withSoftDeletedArtifactType(SoftDeletedArtifactTypes softDeletedArtifactType) {
        this.softDeletedArtifactType = softDeletedArtifactType;
        return this;
    }

    /**
     * Get the softDeletedTime property: The timestamp for when the resource is soft-deleted. In dateTime offset format.
     * 
     * @return the softDeletedTime value.
     */
    public String softDeletedTime() {
        return this.softDeletedTime;
    }

    /**
     * Set the softDeletedTime property: The timestamp for when the resource is soft-deleted. In dateTime offset format.
     * 
     * @param softDeletedTime the softDeletedTime value to set.
     * @return the GallerySoftDeletedResourceProperties object itself.
     */
    public GallerySoftDeletedResourceProperties withSoftDeletedTime(String softDeletedTime) {
        this.softDeletedTime = softDeletedTime;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceArmId", this.resourceArmId);
        jsonWriter.writeStringField("softDeletedArtifactType",
            this.softDeletedArtifactType == null ? null : this.softDeletedArtifactType.toString());
        jsonWriter.writeStringField("softDeletedTime", this.softDeletedTime);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GallerySoftDeletedResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GallerySoftDeletedResourceProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GallerySoftDeletedResourceProperties.
     */
    public static GallerySoftDeletedResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GallerySoftDeletedResourceProperties deserializedGallerySoftDeletedResourceProperties
                = new GallerySoftDeletedResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceArmId".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceProperties.resourceArmId = reader.getString();
                } else if ("softDeletedArtifactType".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceProperties.softDeletedArtifactType
                        = SoftDeletedArtifactTypes.fromString(reader.getString());
                } else if ("softDeletedTime".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceProperties.softDeletedTime = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGallerySoftDeletedResourceProperties;
        });
    }
}
