// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.PirSharedGalleryResource;
import com.azure.resourcemanager.compute.models.SharedGalleryImageVersionStorageProfile;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Specifies information about the gallery image version that you want to create or update.
 */
@Fluent
public final class SharedGalleryImageVersionInner extends PirSharedGalleryResource {
    /*
     * Describes the properties of a gallery image version.
     */
    private SharedGalleryImageVersionProperties innerProperties;

    /*
     * The identifier information of shared gallery.
     */
    private SharedGalleryIdentifier innerIdentifier;

    /*
     * Resource location
     */
    private String location;

    /*
     * Resource name
     */
    private String name;

    /**
     * Creates an instance of SharedGalleryImageVersionInner class.
     */
    public SharedGalleryImageVersionInner() {
    }

    /**
     * Get the innerProperties property: Describes the properties of a gallery image version.
     * 
     * @return the innerProperties value.
     */
    private SharedGalleryImageVersionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the innerIdentifier property: The identifier information of shared gallery.
     * 
     * @return the innerIdentifier value.
     */
    private SharedGalleryIdentifier innerIdentifier() {
        return this.innerIdentifier;
    }

    /**
     * Get the location property: Resource location.
     * 
     * @return the location value.
     */
    @Override
    public String location() {
        return this.location;
    }

    /**
     * Get the name property: Resource name.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the uniqueId property: The unique id of this shared gallery.
     * 
     * @return the uniqueId value.
     */
    public String uniqueId() {
        return this.innerIdentifier() == null ? null : this.innerIdentifier().uniqueId();
    }

    /**
     * Set the uniqueId property: The unique id of this shared gallery.
     * 
     * @param uniqueId the uniqueId value to set.
     * @return the SharedGalleryImageVersionInner object itself.
     */
    public SharedGalleryImageVersionInner withUniqueId(String uniqueId) {
        if (this.innerIdentifier() == null) {
            this.innerIdentifier = new SharedGalleryIdentifier();
        }
        this.innerIdentifier().withUniqueId(uniqueId);
        return this;
    }

    /**
     * Get the publishedDate property: The published date of the gallery image version Definition. This property can be
     * used for decommissioning purposes. This property is updatable.
     * 
     * @return the publishedDate value.
     */
    public OffsetDateTime publishedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().publishedDate();
    }

    /**
     * Set the publishedDate property: The published date of the gallery image version Definition. This property can be
     * used for decommissioning purposes. This property is updatable.
     * 
     * @param publishedDate the publishedDate value to set.
     * @return the SharedGalleryImageVersionInner object itself.
     */
    public SharedGalleryImageVersionInner withPublishedDate(OffsetDateTime publishedDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SharedGalleryImageVersionProperties();
        }
        this.innerProperties().withPublishedDate(publishedDate);
        return this;
    }

    /**
     * Get the endOfLifeDate property: The end of life date of the gallery image version Definition. This property can
     * be used for decommissioning purposes. This property is updatable.
     * 
     * @return the endOfLifeDate value.
     */
    public OffsetDateTime endOfLifeDate() {
        return this.innerProperties() == null ? null : this.innerProperties().endOfLifeDate();
    }

    /**
     * Set the endOfLifeDate property: The end of life date of the gallery image version Definition. This property can
     * be used for decommissioning purposes. This property is updatable.
     * 
     * @param endOfLifeDate the endOfLifeDate value to set.
     * @return the SharedGalleryImageVersionInner object itself.
     */
    public SharedGalleryImageVersionInner withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SharedGalleryImageVersionProperties();
        }
        this.innerProperties().withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    /**
     * Get the excludeFromLatest property: If set to true, Virtual Machines deployed from the latest version of the
     * Image Definition won't use this Image Version.
     * 
     * @return the excludeFromLatest value.
     */
    public Boolean excludeFromLatest() {
        return this.innerProperties() == null ? null : this.innerProperties().excludeFromLatest();
    }

    /**
     * Set the excludeFromLatest property: If set to true, Virtual Machines deployed from the latest version of the
     * Image Definition won't use this Image Version.
     * 
     * @param excludeFromLatest the excludeFromLatest value to set.
     * @return the SharedGalleryImageVersionInner object itself.
     */
    public SharedGalleryImageVersionInner withExcludeFromLatest(Boolean excludeFromLatest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SharedGalleryImageVersionProperties();
        }
        this.innerProperties().withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    /**
     * Get the storageProfile property: Describes the storage profile of the image version.
     * 
     * @return the storageProfile value.
     */
    public SharedGalleryImageVersionStorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    /**
     * Set the storageProfile property: Describes the storage profile of the image version.
     * 
     * @param storageProfile the storageProfile value to set.
     * @return the SharedGalleryImageVersionInner object itself.
     */
    public SharedGalleryImageVersionInner withStorageProfile(SharedGalleryImageVersionStorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SharedGalleryImageVersionProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    /**
     * Get the artifactTags property: The artifact tags of a shared gallery resource.
     * 
     * @return the artifactTags value.
     */
    public Map<String, String> artifactTags() {
        return this.innerProperties() == null ? null : this.innerProperties().artifactTags();
    }

    /**
     * Set the artifactTags property: The artifact tags of a shared gallery resource.
     * 
     * @param artifactTags the artifactTags value to set.
     * @return the SharedGalleryImageVersionInner object itself.
     */
    public SharedGalleryImageVersionInner withArtifactTags(Map<String, String> artifactTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SharedGalleryImageVersionProperties();
        }
        this.innerProperties().withArtifactTags(artifactTags);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (innerIdentifier() != null) {
            innerIdentifier().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identifier", innerIdentifier());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharedGalleryImageVersionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharedGalleryImageVersionInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SharedGalleryImageVersionInner.
     */
    public static SharedGalleryImageVersionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharedGalleryImageVersionInner deserializedSharedGalleryImageVersionInner
                = new SharedGalleryImageVersionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionInner.name = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionInner.location = reader.getString();
                } else if ("identifier".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionInner.innerIdentifier
                        = SharedGalleryIdentifier.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionInner.innerProperties
                        = SharedGalleryImageVersionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharedGalleryImageVersionInner;
        });
    }
}
