// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.GalleryImageVersionsClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryImageVersionInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryImageVersionList;
import com.azure.resourcemanager.compute.models.GalleryImageVersionUpdate;
import com.azure.resourcemanager.compute.models.ReplicationStatusTypes;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in GalleryImageVersionsClient.
 */
public final class GalleryImageVersionsClientImpl implements GalleryImageVersionsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final GalleryImageVersionsService service;

    /**
     * The service client containing this operation class.
     */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of GalleryImageVersionsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    GalleryImageVersionsClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(GalleryImageVersionsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientGalleryImageVersions to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementClientGalleryImageVersions")
    public interface GalleryImageVersionsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryImageVersionList>> listByGalleryImage(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("galleryImageName") String galleryImageName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryImageVersionInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("galleryImageName") String galleryImageName,
            @PathParam("galleryImageVersionName") String galleryImageVersionName,
            @QueryParam("$expand") ReplicationStatusTypes expand, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        @ExpectedResponses({ 200, 201, 202 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("galleryImageName") String galleryImageName,
            @PathParam("galleryImageVersionName") String galleryImageVersionName,
            @BodyParam("application/json") GalleryImageVersionInner galleryImageVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("galleryImageName") String galleryImageName,
            @PathParam("galleryImageVersionName") String galleryImageVersionName,
            @BodyParam("application/json") GalleryImageVersionUpdate galleryImageVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("galleryImageName") String galleryImageName,
            @PathParam("galleryImageVersionName") String galleryImageVersionName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryImageVersionList>> listByGalleryImageNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * List gallery image versions in a gallery image definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Image version operation response along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryImageVersionInner>> listByGalleryImageSinglePageAsync(String resourceGroupName,
        String galleryName, String galleryImageName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByGalleryImage(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryImageName, accept, context))
            .<PagedResponse<GalleryImageVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List gallery image versions in a gallery image definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Image version operation response along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryImageVersionInner>> listByGalleryImageSinglePageAsync(String resourceGroupName,
        String galleryName, String galleryImageName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByGalleryImage(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, galleryName, galleryImageName, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List gallery image versions in a gallery image definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Image version operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GalleryImageVersionInner> listByGalleryImageAsync(String resourceGroupName, String galleryName,
        String galleryImageName) {
        return new PagedFlux<>(
            () -> listByGalleryImageSinglePageAsync(resourceGroupName, galleryName, galleryImageName),
            nextLink -> listByGalleryImageNextSinglePageAsync(nextLink));
    }

    /**
     * List gallery image versions in a gallery image definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Image version operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GalleryImageVersionInner> listByGalleryImageAsync(String resourceGroupName, String galleryName,
        String galleryImageName, Context context) {
        return new PagedFlux<>(
            () -> listByGalleryImageSinglePageAsync(resourceGroupName, galleryName, galleryImageName, context),
            nextLink -> listByGalleryImageNextSinglePageAsync(nextLink, context));
    }

    /**
     * List gallery image versions in a gallery image definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Image version operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryImageVersionInner> listByGalleryImage(String resourceGroupName, String galleryName,
        String galleryImageName) {
        return new PagedIterable<>(listByGalleryImageAsync(resourceGroupName, galleryName, galleryImageName));
    }

    /**
     * List gallery image versions in a gallery image definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Image version operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryImageVersionInner> listByGalleryImage(String resourceGroupName, String galleryName,
        String galleryImageName, Context context) {
        return new PagedIterable<>(listByGalleryImageAsync(resourceGroupName, galleryName, galleryImageName, context));
    }

    /**
     * Retrieves information about a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GalleryImageVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves information about a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GalleryImageVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            galleryName, galleryImageName, galleryImageVersionName, expand, accept, context);
    }

    /**
     * Retrieves information about a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryImageVersionInner> getAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName) {
        final ReplicationStatusTypes expand = null;
        return getWithResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves information about a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GalleryImageVersionInner> getWithResponse(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand, Context context) {
        return getWithResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand,
            context).block();
    }

    /**
     * Retrieves information about a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryImageVersionInner get(String resourceGroupName, String galleryName, String galleryImageName,
        String galleryImageVersionName) {
        final ReplicationStatusTypes expand = null;
        return getWithResponse(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand,
            Context.NONE).getValue();
    }

    /**
     * Create or update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String galleryName, String galleryImageName, String galleryImageVersionName,
        GalleryImageVersionInner galleryImageVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        if (galleryImageVersion == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageVersion is required and cannot be null."));
        } else {
            galleryImageVersion.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryImageName,
                galleryImageVersionName, galleryImageVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String galleryName, String galleryImageName, String galleryImageVersionName,
        GalleryImageVersionInner galleryImageVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        if (galleryImageVersion == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageVersion is required and cannot be null."));
        } else {
            galleryImageVersion.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
            resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion, accept,
            context);
    }

    /**
     * Create or update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery image version that you want
     * to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryImageVersionInner>, GalleryImageVersionInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName,
        GalleryImageVersionInner galleryImageVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, galleryName,
            galleryImageName, galleryImageVersionName, galleryImageVersion);
        return this.client.<GalleryImageVersionInner, GalleryImageVersionInner>getLroResult(mono,
            this.client.getHttpPipeline(), GalleryImageVersionInner.class, GalleryImageVersionInner.class,
            this.client.getContext());
    }

    /**
     * Create or update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery image version that you want
     * to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryImageVersionInner>, GalleryImageVersionInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName,
        GalleryImageVersionInner galleryImageVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, galleryName,
            galleryImageName, galleryImageVersionName, galleryImageVersion, context);
        return this.client.<GalleryImageVersionInner, GalleryImageVersionInner>getLroResult(mono,
            this.client.getHttpPipeline(), GalleryImageVersionInner.class, GalleryImageVersionInner.class, context);
    }

    /**
     * Create or update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery image version that you want
     * to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryImageVersionInner>, GalleryImageVersionInner> beginCreateOrUpdate(
        String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName,
        GalleryImageVersionInner galleryImageVersion) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
                galleryImageVersion)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery image version that you want
     * to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryImageVersionInner>, GalleryImageVersionInner> beginCreateOrUpdate(
        String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName,
        GalleryImageVersionInner galleryImageVersion, Context context) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
                galleryImageVersion, context)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryImageVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
            galleryImageVersion).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryImageVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
            galleryImageVersion, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryImageVersionInner createOrUpdate(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        return createOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
            galleryImageVersion).block();
    }

    /**
     * Create or update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryImageVersionInner createOrUpdate(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
            galleryImageVersion, context).block();
    }

    /**
     * Update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        if (galleryImageVersion == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageVersion is required and cannot be null."));
        } else {
            galleryImageVersion.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryImageName,
                galleryImageVersionName, galleryImageVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the update gallery image version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        if (galleryImageVersion == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageVersion is required and cannot be null."));
        } else {
            galleryImageVersion.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion, accept, context);
    }

    /**
     * Update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery image version that you want
     * to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryImageVersionInner>, GalleryImageVersionInner> beginUpdateAsync(
        String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName,
        GalleryImageVersionUpdate galleryImageVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, galleryName,
            galleryImageName, galleryImageVersionName, galleryImageVersion);
        return this.client.<GalleryImageVersionInner, GalleryImageVersionInner>getLroResult(mono,
            this.client.getHttpPipeline(), GalleryImageVersionInner.class, GalleryImageVersionInner.class,
            this.client.getContext());
    }

    /**
     * Update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the update gallery image version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery image version that you want
     * to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryImageVersionInner>, GalleryImageVersionInner> beginUpdateAsync(
        String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName,
        GalleryImageVersionUpdate galleryImageVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, galleryName,
            galleryImageName, galleryImageVersionName, galleryImageVersion, context);
        return this.client.<GalleryImageVersionInner, GalleryImageVersionInner>getLroResult(mono,
            this.client.getHttpPipeline(), GalleryImageVersionInner.class, GalleryImageVersionInner.class, context);
    }

    /**
     * Update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery image version that you want
     * to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryImageVersionInner>, GalleryImageVersionInner> beginUpdate(
        String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName,
        GalleryImageVersionUpdate galleryImageVersion) {
        return this
            .beginUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
                galleryImageVersion)
            .getSyncPoller();
    }

    /**
     * Update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the update gallery image version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery image version that you want
     * to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryImageVersionInner>, GalleryImageVersionInner> beginUpdate(
        String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName,
        GalleryImageVersionUpdate galleryImageVersion, Context context) {
        return this
            .beginUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
                galleryImageVersion, context)
            .getSyncPoller();
    }

    /**
     * Update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryImageVersionInner> updateAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion) {
        return beginUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
            galleryImageVersion).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the update gallery image version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryImageVersionInner> updateAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion,
        Context context) {
        return beginUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
            galleryImageVersion, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryImageVersionInner update(String resourceGroupName, String galleryName, String galleryImageName,
        String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion) {
        return updateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
            galleryImageVersion).block();
    }

    /**
     * Update a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryImageVersion Parameters supplied to the update gallery image version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery image version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryImageVersionInner update(String resourceGroupName, String galleryName, String galleryImageName,
        String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion, Context context) {
        return updateAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName,
            galleryImageVersion, context).block();
    }

    /**
     * Delete a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                    resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            galleryName, galleryImageName, galleryImageVersionName, accept, context);
    }

    /**
     * Delete a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, galleryName,
            galleryImageName, galleryImageVersionName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName)
            .getSyncPoller();
    }

    /**
     * Delete a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String galleryImageName, String galleryImageVersionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, context)
            .getSyncPoller();
    }

    /**
     * Delete a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryImageName,
        String galleryImageVersionName) {
        return beginDeleteAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryImageName,
        String galleryImageVersionName, Context context) {
        return beginDeleteAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String galleryImageName,
        String galleryImageVersionName) {
        deleteAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).block();
    }

    /**
     * Delete a gallery image version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String galleryImageName,
        String galleryImageVersionName, Context context) {
        deleteAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Image version operation response along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryImageVersionInner>> listByGalleryImageNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByGalleryImageNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<GalleryImageVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Image version operation response along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryImageVersionInner>> listByGalleryImageNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByGalleryImageNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
