// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.GalleryInVMAccessControlProfileVersionsClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryInVMAccessControlProfileVersionInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileVersionList;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileVersionUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * GalleryInVMAccessControlProfileVersionsClient.
 */
public final class GalleryInVMAccessControlProfileVersionsClientImpl
    implements GalleryInVMAccessControlProfileVersionsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final GalleryInVMAccessControlProfileVersionsService service;

    /**
     * The service client containing this operation class.
     */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of GalleryInVMAccessControlProfileVersionsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    GalleryInVMAccessControlProfileVersionsClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(GalleryInVMAccessControlProfileVersionsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientGalleryInVMAccessControlProfileVersions to be
     * used by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementClientGalleryInVMAccessControlProfileVersions")
    public interface GalleryInVMAccessControlProfileVersionsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryInVMAccessControlProfileVersionList>> listByGalleryInVMAccessControlProfile(
            @HostParam("$host") String endpoint, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("inVMAccessControlProfileName") String inVMAccessControlProfileName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}/versions/{inVMAccessControlProfileVersionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryInVMAccessControlProfileVersionInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("inVMAccessControlProfileName") String inVMAccessControlProfileName,
            @PathParam("inVMAccessControlProfileVersionName") String inVMAccessControlProfileVersionName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}/versions/{inVMAccessControlProfileVersionName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("inVMAccessControlProfileName") String inVMAccessControlProfileName,
            @PathParam("inVMAccessControlProfileVersionName") String inVMAccessControlProfileVersionName,
            @BodyParam("application/json") GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}/versions/{inVMAccessControlProfileVersionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("inVMAccessControlProfileName") String inVMAccessControlProfileName,
            @PathParam("inVMAccessControlProfileVersionName") String inVMAccessControlProfileVersionName,
            @BodyParam("application/json") GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}/versions/{inVMAccessControlProfileVersionName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("inVMAccessControlProfileName") String inVMAccessControlProfileName,
            @PathParam("inVMAccessControlProfileVersionName") String inVMAccessControlProfileVersionName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryInVMAccessControlProfileVersionList>> listByGalleryInVMAccessControlProfileNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * List gallery inVMAccessControlProfile versions in a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileVersionInner>>
        listByGalleryInVMAccessControlProfileSinglePageAsync(String resourceGroupName, String galleryName,
            String inVMAccessControlProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByGalleryInVMAccessControlProfile(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, accept,
                context))
            .<PagedResponse<GalleryInVMAccessControlProfileVersionInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List gallery inVMAccessControlProfile versions in a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileVersionInner>>
        listByGalleryInVMAccessControlProfileSinglePageAsync(String resourceGroupName, String galleryName,
            String inVMAccessControlProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByGalleryInVMAccessControlProfile(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List gallery inVMAccessControlProfile versions in a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfileAsync(
        String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        return new PagedFlux<>(
            () -> listByGalleryInVMAccessControlProfileSinglePageAsync(resourceGroupName, galleryName,
                inVMAccessControlProfileName),
            nextLink -> listByGalleryInVMAccessControlProfileNextSinglePageAsync(nextLink));
    }

    /**
     * List gallery inVMAccessControlProfile versions in a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfileAsync(
        String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        return new PagedFlux<>(
            () -> listByGalleryInVMAccessControlProfileSinglePageAsync(resourceGroupName, galleryName,
                inVMAccessControlProfileName, context),
            nextLink -> listByGalleryInVMAccessControlProfileNextSinglePageAsync(nextLink, context));
    }

    /**
     * List gallery inVMAccessControlProfile versions in a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfile(
        String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        return new PagedIterable<>(
            listByGalleryInVMAccessControlProfileAsync(resourceGroupName, galleryName, inVMAccessControlProfileName));
    }

    /**
     * List gallery inVMAccessControlProfile versions in a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfile(
        String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        return new PagedIterable<>(listByGalleryInVMAccessControlProfileAsync(resourceGroupName, galleryName,
            inVMAccessControlProfileName, context));
    }

    /**
     * Retrieves information about a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GalleryInVMAccessControlProfileVersionInner>> getWithResponseAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves information about a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GalleryInVMAccessControlProfileVersionInner>> getWithResponseAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, accept, context);
    }

    /**
     * Retrieves information about a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileVersionInner> getAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        return getWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves information about a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GalleryInVMAccessControlProfileVersionInner> getWithResponse(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        Context context) {
        return getWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, context).block();
    }

    /**
     * Retrieves information about a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileVersionInner get(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        return getWithResponse(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, Context.NONE).getValue();
    }

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfileVersion == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter galleryInVMAccessControlProfileVersion is required and cannot be null."));
        } else {
            galleryInVMAccessControlProfileVersion.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfileVersion == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter galleryInVMAccessControlProfileVersion is required and cannot be null."));
        } else {
            galleryInVMAccessControlProfileVersion.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
            resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName,
            galleryInVMAccessControlProfileVersion, accept, context);
    }

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, galleryName,
            inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion);
        return this.client
            .<GalleryInVMAccessControlProfileVersionInner, GalleryInVMAccessControlProfileVersionInner>getLroResult(
                mono, this.client.getHttpPipeline(), GalleryInVMAccessControlProfileVersionInner.class,
                GalleryInVMAccessControlProfileVersionInner.class, this.client.getContext());
    }

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context);
        return this.client
            .<GalleryInVMAccessControlProfileVersionInner, GalleryInVMAccessControlProfileVersionInner>getLroResult(
                mono, this.client.getHttpPipeline(), GalleryInVMAccessControlProfileVersionInner.class,
                GalleryInVMAccessControlProfileVersionInner.class, context);
    }

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileVersionInner> createOrUpdateAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryInVMAccessControlProfileVersionInner> createOrUpdateAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileVersionInner createOrUpdate(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion) {
        return createOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion).block();
    }

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileVersionInner createOrUpdate(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context) {
        return createOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context).block();
    }

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfileVersion == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter galleryInVMAccessControlProfileVersion is required and cannot be null."));
        } else {
            galleryInVMAccessControlProfileVersion.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfileVersion == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter galleryInVMAccessControlProfileVersion is required and cannot be null."));
        } else {
            galleryInVMAccessControlProfileVersion.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName,
            galleryInVMAccessControlProfileVersion, accept, context);
    }

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, galleryName,
            inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion);
        return this.client
            .<GalleryInVMAccessControlProfileVersionInner, GalleryInVMAccessControlProfileVersionInner>getLroResult(
                mono, this.client.getHttpPipeline(), GalleryInVMAccessControlProfileVersionInner.class,
                GalleryInVMAccessControlProfileVersionInner.class, this.client.getContext());
    }

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context);
        return this.client
            .<GalleryInVMAccessControlProfileVersionInner, GalleryInVMAccessControlProfileVersionInner>getLroResult(
                mono, this.client.getHttpPipeline(), GalleryInVMAccessControlProfileVersionInner.class,
                GalleryInVMAccessControlProfileVersionInner.class, context);
    }

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion) {
        return this
            .beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion)
            .getSyncPoller();
    }

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context) {
        return this
            .beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context)
            .getSyncPoller();
    }

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileVersionInner> updateAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion) {
        return beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryInVMAccessControlProfileVersionInner> updateAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context) {
        return beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileVersionInner update(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion) {
        return updateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion).block();
    }

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileVersionInner update(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context) {
        return updateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context).block();
    }

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, accept, context);
    }

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, galleryName,
            inVMAccessControlProfileName, inVMAccessControlProfileVersionName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, galleryName,
            inVMAccessControlProfileName, inVMAccessControlProfileVersionName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        return this
            .beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName)
            .getSyncPoller();
    }

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context) {
        return this
            .beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                inVMAccessControlProfileVersionName, context)
            .getSyncPoller();
    }

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        String inVMAccessControlProfileVersionName) {
        return beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        String inVMAccessControlProfileVersionName, Context context) {
        return beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            inVMAccessControlProfileVersionName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        String inVMAccessControlProfileVersionName) {
        deleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName)
            .block();
    }

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        String inVMAccessControlProfileVersionName, Context context) {
        deleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName,
            context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileVersionInner>>
        listByGalleryInVMAccessControlProfileNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByGalleryInVMAccessControlProfileNext(nextLink,
                this.client.getEndpoint(), accept, context))
            .<PagedResponse<GalleryInVMAccessControlProfileVersionInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileVersionInner>>
        listByGalleryInVMAccessControlProfileNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByGalleryInVMAccessControlProfileNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
