// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.DiskEncryptionSetInner;
import java.io.IOException;
import java.util.List;

/**
 * The List disk encryption set operation response.
 */
@Fluent
public final class DiskEncryptionSetList implements JsonSerializable<DiskEncryptionSetList> {
    /*
     * The DiskEncryptionSet items on this page
     */
    private List<DiskEncryptionSetInner> value;

    /*
     * The link to the next page of items
     */
    private String nextLink;

    /**
     * Creates an instance of DiskEncryptionSetList class.
     */
    public DiskEncryptionSetList() {
    }

    /**
     * Get the value property: The DiskEncryptionSet items on this page.
     * 
     * @return the value value.
     */
    public List<DiskEncryptionSetInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The DiskEncryptionSet items on this page.
     * 
     * @param value the value value to set.
     * @return the DiskEncryptionSetList object itself.
     */
    public DiskEncryptionSetList withValue(List<DiskEncryptionSetInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link to the next page of items.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link to the next page of items.
     * 
     * @param nextLink the nextLink value to set.
     * @return the DiskEncryptionSetList object itself.
     */
    public DiskEncryptionSetList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model DiskEncryptionSetList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DiskEncryptionSetList.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskEncryptionSetList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskEncryptionSetList if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DiskEncryptionSetList.
     */
    public static DiskEncryptionSetList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskEncryptionSetList deserializedDiskEncryptionSetList = new DiskEncryptionSetList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DiskEncryptionSetInner> value
                        = reader.readArray(reader1 -> DiskEncryptionSetInner.fromJson(reader1));
                    deserializedDiskEncryptionSetList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedDiskEncryptionSetList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskEncryptionSetList;
        });
    }
}
