// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the Virtual Machine Scale Set to migrate from Availability Set.
 */
@Fluent
public final class MigrateToVirtualMachineScaleSetInput
    implements JsonSerializable<MigrateToVirtualMachineScaleSetInput> {
    /*
     * Specifies information about the Virtual Machine Scale Set that the Availability Set should be migrated to.
     * Minimum api‐version: 2024‐11‐01.
     */
    private SubResource virtualMachineScaleSetFlexible;

    /**
     * Creates an instance of MigrateToVirtualMachineScaleSetInput class.
     */
    public MigrateToVirtualMachineScaleSetInput() {
    }

    /**
     * Get the virtualMachineScaleSetFlexible property: Specifies information about the Virtual Machine Scale Set that
     * the Availability Set should be migrated to. Minimum api‐version: 2024‐11‐01.
     * 
     * @return the virtualMachineScaleSetFlexible value.
     */
    public SubResource virtualMachineScaleSetFlexible() {
        return this.virtualMachineScaleSetFlexible;
    }

    /**
     * Set the virtualMachineScaleSetFlexible property: Specifies information about the Virtual Machine Scale Set that
     * the Availability Set should be migrated to. Minimum api‐version: 2024‐11‐01.
     * 
     * @param virtualMachineScaleSetFlexible the virtualMachineScaleSetFlexible value to set.
     * @return the MigrateToVirtualMachineScaleSetInput object itself.
     */
    public MigrateToVirtualMachineScaleSetInput
        withVirtualMachineScaleSetFlexible(SubResource virtualMachineScaleSetFlexible) {
        this.virtualMachineScaleSetFlexible = virtualMachineScaleSetFlexible;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (virtualMachineScaleSetFlexible() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property virtualMachineScaleSetFlexible in model MigrateToVirtualMachineScaleSetInput"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MigrateToVirtualMachineScaleSetInput.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualMachineScaleSetFlexible", this.virtualMachineScaleSetFlexible);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrateToVirtualMachineScaleSetInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrateToVirtualMachineScaleSetInput if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MigrateToVirtualMachineScaleSetInput.
     */
    public static MigrateToVirtualMachineScaleSetInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrateToVirtualMachineScaleSetInput deserializedMigrateToVirtualMachineScaleSetInput
                = new MigrateToVirtualMachineScaleSetInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualMachineScaleSetFlexible".equals(fieldName)) {
                    deserializedMigrateToVirtualMachineScaleSetInput.virtualMachineScaleSetFlexible
                        = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrateToVirtualMachineScaleSetInput;
        });
    }
}
