// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.ProximityPlacementGroupInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Proximity Placement Group operation response.
 */
@Fluent
public final class ProximityPlacementGroupListResult implements JsonSerializable<ProximityPlacementGroupListResult> {
    /*
     * The list of proximity placement groups.
     */
    private List<ProximityPlacementGroupInner> value;

    /*
     * The URI to fetch the next page of proximity placement groups.
     */
    private String nextLink;

    /**
     * Creates an instance of ProximityPlacementGroupListResult class.
     */
    public ProximityPlacementGroupListResult() {
    }

    /**
     * Get the value property: The list of proximity placement groups.
     * 
     * @return the value value.
     */
    public List<ProximityPlacementGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of proximity placement groups.
     * 
     * @param value the value value to set.
     * @return the ProximityPlacementGroupListResult object itself.
     */
    public ProximityPlacementGroupListResult withValue(List<ProximityPlacementGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of proximity placement groups.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of proximity placement groups.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ProximityPlacementGroupListResult object itself.
     */
    public ProximityPlacementGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model ProximityPlacementGroupListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ProximityPlacementGroupListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProximityPlacementGroupListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProximityPlacementGroupListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ProximityPlacementGroupListResult.
     */
    public static ProximityPlacementGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProximityPlacementGroupListResult deserializedProximityPlacementGroupListResult
                = new ProximityPlacementGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ProximityPlacementGroupInner> value
                        = reader.readArray(reader1 -> ProximityPlacementGroupInner.fromJson(reader1));
                    deserializedProximityPlacementGroupListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedProximityPlacementGroupListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProximityPlacementGroupListResult;
        });
    }
}
