// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains information about the soft deletion policy of the gallery.
 */
@Fluent
public final class SoftDeletePolicy implements JsonSerializable<SoftDeletePolicy> {
    /*
     * Enables soft-deletion for resources in this gallery, allowing them to be recovered within retention time.
     */
    private Boolean isSoftDeleteEnabled;

    /**
     * Creates an instance of SoftDeletePolicy class.
     */
    public SoftDeletePolicy() {
    }

    /**
     * Get the isSoftDeleteEnabled property: Enables soft-deletion for resources in this gallery, allowing them to be
     * recovered within retention time.
     * 
     * @return the isSoftDeleteEnabled value.
     */
    public Boolean isSoftDeleteEnabled() {
        return this.isSoftDeleteEnabled;
    }

    /**
     * Set the isSoftDeleteEnabled property: Enables soft-deletion for resources in this gallery, allowing them to be
     * recovered within retention time.
     * 
     * @param isSoftDeleteEnabled the isSoftDeleteEnabled value to set.
     * @return the SoftDeletePolicy object itself.
     */
    public SoftDeletePolicy withIsSoftDeleteEnabled(Boolean isSoftDeleteEnabled) {
        this.isSoftDeleteEnabled = isSoftDeleteEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isSoftDeleteEnabled", this.isSoftDeleteEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SoftDeletePolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SoftDeletePolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SoftDeletePolicy.
     */
    public static SoftDeletePolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SoftDeletePolicy deserializedSoftDeletePolicy = new SoftDeletePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isSoftDeleteEnabled".equals(fieldName)) {
                    deserializedSoftDeletePolicy.isSoftDeleteEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSoftDeletePolicy;
        });
    }
}
