// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the Availability Set properties related to migration to Flexible Virtual Machine Scale Set.
 */
@Immutable
public final class VirtualMachineScaleSetMigrationInfo
    implements JsonSerializable<VirtualMachineScaleSetMigrationInfo> {
    /*
     * Indicates the target Virtual Machine ScaleSet properties upon triggering a seamless migration without downtime of
     * the VMs via the ConvertToVirtualMachineScaleSet API.
     */
    private DefaultVirtualMachineScaleSetInfo defaultVirtualMachineScaleSetInfo;

    /*
     * Specifies the Virtual Machine Scale Set that the Availability Set is migrated to.
     */
    private SubResource migrateToVirtualMachineScaleSet;

    /**
     * Creates an instance of VirtualMachineScaleSetMigrationInfo class.
     */
    public VirtualMachineScaleSetMigrationInfo() {
    }

    /**
     * Get the defaultVirtualMachineScaleSetInfo property: Indicates the target Virtual Machine ScaleSet properties upon
     * triggering a seamless migration without downtime of the VMs via the ConvertToVirtualMachineScaleSet API.
     * 
     * @return the defaultVirtualMachineScaleSetInfo value.
     */
    public DefaultVirtualMachineScaleSetInfo defaultVirtualMachineScaleSetInfo() {
        return this.defaultVirtualMachineScaleSetInfo;
    }

    /**
     * Get the migrateToVirtualMachineScaleSet property: Specifies the Virtual Machine Scale Set that the Availability
     * Set is migrated to.
     * 
     * @return the migrateToVirtualMachineScaleSet value.
     */
    public SubResource migrateToVirtualMachineScaleSet() {
        return this.migrateToVirtualMachineScaleSet;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (defaultVirtualMachineScaleSetInfo() != null) {
            defaultVirtualMachineScaleSetInfo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetMigrationInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetMigrationInfo if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetMigrationInfo.
     */
    public static VirtualMachineScaleSetMigrationInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetMigrationInfo deserializedVirtualMachineScaleSetMigrationInfo
                = new VirtualMachineScaleSetMigrationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defaultVirtualMachineScaleSetInfo".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetMigrationInfo.defaultVirtualMachineScaleSetInfo
                        = DefaultVirtualMachineScaleSetInfo.fromJson(reader);
                } else if ("migrateToVirtualMachineScaleSet".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetMigrationInfo.migrateToVirtualMachineScaleSet
                        = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetMigrationInfo;
        });
    }
}
