// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Virtual Machine Scale Set VMs operation response.
 */
@Fluent
public final class VirtualMachineScaleSetVMListResult implements JsonSerializable<VirtualMachineScaleSetVMListResult> {
    /*
     * The list of virtual machine scale sets VMs.
     */
    private List<VirtualMachineScaleSetVMInner> value;

    /*
     * The uri to fetch the next page of Virtual Machine Scale Set VMs. Call ListNext() with this to fetch the next page
     * of VMSS VMs.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualMachineScaleSetVMListResult class.
     */
    public VirtualMachineScaleSetVMListResult() {
    }

    /**
     * Get the value property: The list of virtual machine scale sets VMs.
     * 
     * @return the value value.
     */
    public List<VirtualMachineScaleSetVMInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of virtual machine scale sets VMs.
     * 
     * @param value the value value to set.
     * @return the VirtualMachineScaleSetVMListResult object itself.
     */
    public VirtualMachineScaleSetVMListResult withValue(List<VirtualMachineScaleSetVMInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call ListNext() with
     * this to fetch the next page of VMSS VMs.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call ListNext() with
     * this to fetch the next page of VMSS VMs.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VirtualMachineScaleSetVMListResult object itself.
     */
    public VirtualMachineScaleSetVMListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model VirtualMachineScaleSetVMListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetVMListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetVMListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetVMListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetVMListResult.
     */
    public static VirtualMachineScaleSetVMListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMListResult deserializedVirtualMachineScaleSetVMListResult
                = new VirtualMachineScaleSetVMListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualMachineScaleSetVMInner> value
                        = reader.readArray(reader1 -> VirtualMachineScaleSetVMInner.fromJson(reader1));
                    deserializedVirtualMachineScaleSetVMListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetVMListResult;
        });
    }
}
