/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CommunityGalleryMetadata
implements JsonSerializable<CommunityGalleryMetadata> {
    private String publisherUri;
    private String publisherContact;
    private String eula;
    private List<String> publicNames;
    private String privacyStatementUri;
    private static final ClientLogger LOGGER = new ClientLogger(CommunityGalleryMetadata.class);

    public String publisherUri() {
        return this.publisherUri;
    }

    public CommunityGalleryMetadata withPublisherUri(String publisherUri) {
        this.publisherUri = publisherUri;
        return this;
    }

    public String publisherContact() {
        return this.publisherContact;
    }

    public CommunityGalleryMetadata withPublisherContact(String publisherContact) {
        this.publisherContact = publisherContact;
        return this;
    }

    public String eula() {
        return this.eula;
    }

    public CommunityGalleryMetadata withEula(String eula) {
        this.eula = eula;
        return this;
    }

    public List<String> publicNames() {
        return this.publicNames;
    }

    public CommunityGalleryMetadata withPublicNames(List<String> publicNames) {
        this.publicNames = publicNames;
        return this;
    }

    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    public CommunityGalleryMetadata withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    public void validate() {
        if (this.publisherContact() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publisherContact in model CommunityGalleryMetadata"));
        }
        if (this.publicNames() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publicNames in model CommunityGalleryMetadata"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publisherContact", this.publisherContact);
        jsonWriter.writeArrayField("publicNames", this.publicNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("publisherUri", this.publisherUri);
        jsonWriter.writeStringField("eula", this.eula);
        jsonWriter.writeStringField("privacyStatementUri", this.privacyStatementUri);
        return jsonWriter.writeEndObject();
    }

    public static CommunityGalleryMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (CommunityGalleryMetadata)jsonReader.readObject(reader -> {
            CommunityGalleryMetadata deserializedCommunityGalleryMetadata = new CommunityGalleryMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publisherContact".equals(fieldName)) {
                    deserializedCommunityGalleryMetadata.publisherContact = reader.getString();
                    continue;
                }
                if ("publicNames".equals(fieldName)) {
                    List publicNames;
                    deserializedCommunityGalleryMetadata.publicNames = publicNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("publisherUri".equals(fieldName)) {
                    deserializedCommunityGalleryMetadata.publisherUri = reader.getString();
                    continue;
                }
                if ("eula".equals(fieldName)) {
                    deserializedCommunityGalleryMetadata.eula = reader.getString();
                    continue;
                }
                if ("privacyStatementUri".equals(fieldName)) {
                    deserializedCommunityGalleryMetadata.privacyStatementUri = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommunityGalleryMetadata;
        });
    }
}

