/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachinePublicIpAddressConfigurationProperties;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.IpVersions;
import com.azure.resourcemanager.compute.models.PublicIpAddressSku;
import com.azure.resourcemanager.compute.models.PublicIpAllocationMethod;
import com.azure.resourcemanager.compute.models.VirtualMachineIpTag;
import com.azure.resourcemanager.compute.models.VirtualMachinePublicIpAddressDnsSettingsConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualMachinePublicIpAddressConfiguration
implements JsonSerializable<VirtualMachinePublicIpAddressConfiguration> {
    private String name;
    private VirtualMachinePublicIpAddressConfigurationProperties innerProperties;
    private PublicIpAddressSku sku;
    private Map<String, String> tags;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachinePublicIpAddressConfiguration.class);

    public String name() {
        return this.name;
    }

    public VirtualMachinePublicIpAddressConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    private VirtualMachinePublicIpAddressConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public PublicIpAddressSku sku() {
        return this.sku;
    }

    public VirtualMachinePublicIpAddressConfiguration withSku(PublicIpAddressSku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public VirtualMachinePublicIpAddressConfiguration withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().idleTimeoutInMinutes();
    }

    public VirtualMachinePublicIpAddressConfiguration withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withIdleTimeoutInMinutes(idleTimeoutInMinutes);
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteOption();
    }

    public VirtualMachinePublicIpAddressConfiguration withDeleteOption(DeleteOptions deleteOption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withDeleteOption(deleteOption);
        return this;
    }

    public VirtualMachinePublicIpAddressDnsSettingsConfiguration dnsSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSettings();
    }

    public VirtualMachinePublicIpAddressConfiguration withDnsSettings(VirtualMachinePublicIpAddressDnsSettingsConfiguration dnsSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withDnsSettings(dnsSettings);
        return this;
    }

    public List<VirtualMachineIpTag> ipTags() {
        return this.innerProperties() == null ? null : this.innerProperties().ipTags();
    }

    public VirtualMachinePublicIpAddressConfiguration withIpTags(List<VirtualMachineIpTag> ipTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withIpTags(ipTags);
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpPrefix();
    }

    public VirtualMachinePublicIpAddressConfiguration withPublicIpPrefix(SubResource publicIpPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withPublicIpPrefix(publicIpPrefix);
        return this;
    }

    public IpVersions publicIpAddressVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddressVersion();
    }

    public VirtualMachinePublicIpAddressConfiguration withPublicIpAddressVersion(IpVersions publicIpAddressVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withPublicIpAddressVersion(publicIpAddressVersion);
        return this;
    }

    public PublicIpAllocationMethod publicIpAllocationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAllocationMethod();
    }

    public VirtualMachinePublicIpAddressConfiguration withPublicIpAllocationMethod(PublicIpAllocationMethod publicIpAllocationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withPublicIpAllocationMethod(publicIpAllocationMethod);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model VirtualMachinePublicIpAddressConfiguration"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachinePublicIpAddressConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachinePublicIpAddressConfiguration)jsonReader.readObject(reader -> {
            VirtualMachinePublicIpAddressConfiguration deserializedVirtualMachinePublicIpAddressConfiguration = new VirtualMachinePublicIpAddressConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachinePublicIpAddressConfiguration.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachinePublicIpAddressConfiguration.innerProperties = VirtualMachinePublicIpAddressConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedVirtualMachinePublicIpAddressConfiguration.sku = PublicIpAddressSku.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedVirtualMachinePublicIpAddressConfiguration.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachinePublicIpAddressConfiguration;
        });
    }
}

