/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.MaxInstancePercentPerZonePolicy;
import java.io.IOException;

public final class ZoneAllocationPolicy
implements JsonSerializable<ZoneAllocationPolicy> {
    private Integer maxZoneCount;
    private MaxInstancePercentPerZonePolicy maxInstancePercentPerZonePolicy;

    public Integer maxZoneCount() {
        return this.maxZoneCount;
    }

    public ZoneAllocationPolicy withMaxZoneCount(Integer maxZoneCount) {
        this.maxZoneCount = maxZoneCount;
        return this;
    }

    public MaxInstancePercentPerZonePolicy maxInstancePercentPerZonePolicy() {
        return this.maxInstancePercentPerZonePolicy;
    }

    public ZoneAllocationPolicy withMaxInstancePercentPerZonePolicy(MaxInstancePercentPerZonePolicy maxInstancePercentPerZonePolicy) {
        this.maxInstancePercentPerZonePolicy = maxInstancePercentPerZonePolicy;
        return this;
    }

    public void validate() {
        if (this.maxInstancePercentPerZonePolicy() != null) {
            this.maxInstancePercentPerZonePolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxZoneCount", (Number)this.maxZoneCount);
        jsonWriter.writeJsonField("maxInstancePercentPerZonePolicy", (JsonSerializable)this.maxInstancePercentPerZonePolicy);
        return jsonWriter.writeEndObject();
    }

    public static ZoneAllocationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ZoneAllocationPolicy)jsonReader.readObject(reader -> {
            ZoneAllocationPolicy deserializedZoneAllocationPolicy = new ZoneAllocationPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxZoneCount".equals(fieldName)) {
                    deserializedZoneAllocationPolicy.maxZoneCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxInstancePercentPerZonePolicy".equals(fieldName)) {
                    deserializedZoneAllocationPolicy.maxInstancePercentPerZonePolicy = MaxInstancePercentPerZonePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedZoneAllocationPolicy;
        });
    }
}

