// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CapacityReservationGroupInstanceView;
import com.azure.resourcemanager.compute.models.ReservationType;
import com.azure.resourcemanager.compute.models.ResourceSharingProfile;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;
import java.util.List;

/**
 * capacity reservation group Properties.
 */
@Fluent
public final class CapacityReservationGroupProperties implements JsonSerializable<CapacityReservationGroupProperties> {
    /*
     * A list of all capacity reservation resource ids that belong to capacity reservation group.
     */
    private List<SubResourceReadOnly> capacityReservations;

    /*
     * A list of references to all virtual machines associated to the capacity reservation group.
     */
    private List<SubResourceReadOnly> virtualMachinesAssociated;

    /*
     * The capacity reservation group instance view which has the list of instance views for all the capacity
     * reservations that belong to the capacity reservation group.
     */
    private CapacityReservationGroupInstanceView instanceView;

    /*
     * Specifies the settings to enable sharing across subscriptions for the capacity reservation group resource. The
     * capacity reservation group resource can generally be shared across subscriptions belonging to a single Azure AAD
     * tenant or across AAD tenants if there is a trust relationship established between the tenants. Block capacity
     * reservation does not support sharing across subscriptions. **Note:** Minimum api-version: 2023-09-01. Please
     * refer to https://aka.ms/computereservationsharing for more details.
     */
    private ResourceSharingProfile sharingProfile;

    /*
     * Indicates the type of capacity reservation. Allowed values are 'Block' for block capacity reservations and
     * 'Targeted' for reservations that enable a VM to consume a specific capacity reservation when a capacity
     * reservation group is provided. The reservation type is immutable and cannot be changed after it is assigned.
     */
    private ReservationType reservationType;

    /**
     * Creates an instance of CapacityReservationGroupProperties class.
     */
    public CapacityReservationGroupProperties() {
    }

    /**
     * Get the capacityReservations property: A list of all capacity reservation resource ids that belong to capacity
     * reservation group.
     * 
     * @return the capacityReservations value.
     */
    public List<SubResourceReadOnly> capacityReservations() {
        return this.capacityReservations;
    }

    /**
     * Get the virtualMachinesAssociated property: A list of references to all virtual machines associated to the
     * capacity reservation group.
     * 
     * @return the virtualMachinesAssociated value.
     */
    public List<SubResourceReadOnly> virtualMachinesAssociated() {
        return this.virtualMachinesAssociated;
    }

    /**
     * Get the instanceView property: The capacity reservation group instance view which has the list of instance views
     * for all the capacity reservations that belong to the capacity reservation group.
     * 
     * @return the instanceView value.
     */
    public CapacityReservationGroupInstanceView instanceView() {
        return this.instanceView;
    }

    /**
     * Get the sharingProfile property: Specifies the settings to enable sharing across subscriptions for the capacity
     * reservation group resource. The capacity reservation group resource can generally be shared across subscriptions
     * belonging to a single Azure AAD tenant or across AAD tenants if there is a trust relationship established between
     * the tenants. Block capacity reservation does not support sharing across subscriptions. **Note:** Minimum
     * api-version: 2023-09-01. Please refer to https://aka.ms/computereservationsharing for more details.
     * 
     * @return the sharingProfile value.
     */
    public ResourceSharingProfile sharingProfile() {
        return this.sharingProfile;
    }

    /**
     * Set the sharingProfile property: Specifies the settings to enable sharing across subscriptions for the capacity
     * reservation group resource. The capacity reservation group resource can generally be shared across subscriptions
     * belonging to a single Azure AAD tenant or across AAD tenants if there is a trust relationship established between
     * the tenants. Block capacity reservation does not support sharing across subscriptions. **Note:** Minimum
     * api-version: 2023-09-01. Please refer to https://aka.ms/computereservationsharing for more details.
     * 
     * @param sharingProfile the sharingProfile value to set.
     * @return the CapacityReservationGroupProperties object itself.
     */
    public CapacityReservationGroupProperties withSharingProfile(ResourceSharingProfile sharingProfile) {
        this.sharingProfile = sharingProfile;
        return this;
    }

    /**
     * Get the reservationType property: Indicates the type of capacity reservation. Allowed values are 'Block' for
     * block capacity reservations and 'Targeted' for reservations that enable a VM to consume a specific capacity
     * reservation when a capacity reservation group is provided. The reservation type is immutable and cannot be
     * changed after it is assigned.
     * 
     * @return the reservationType value.
     */
    public ReservationType reservationType() {
        return this.reservationType;
    }

    /**
     * Set the reservationType property: Indicates the type of capacity reservation. Allowed values are 'Block' for
     * block capacity reservations and 'Targeted' for reservations that enable a VM to consume a specific capacity
     * reservation when a capacity reservation group is provided. The reservation type is immutable and cannot be
     * changed after it is assigned.
     * 
     * @param reservationType the reservationType value to set.
     * @return the CapacityReservationGroupProperties object itself.
     */
    public CapacityReservationGroupProperties withReservationType(ReservationType reservationType) {
        this.reservationType = reservationType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capacityReservations() != null) {
            capacityReservations().forEach(e -> e.validate());
        }
        if (virtualMachinesAssociated() != null) {
            virtualMachinesAssociated().forEach(e -> e.validate());
        }
        if (instanceView() != null) {
            instanceView().validate();
        }
        if (sharingProfile() != null) {
            sharingProfile().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sharingProfile", this.sharingProfile);
        jsonWriter.writeStringField("reservationType",
            this.reservationType == null ? null : this.reservationType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CapacityReservationGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CapacityReservationGroupProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CapacityReservationGroupProperties.
     */
    public static CapacityReservationGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CapacityReservationGroupProperties deserializedCapacityReservationGroupProperties
                = new CapacityReservationGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("capacityReservations".equals(fieldName)) {
                    List<SubResourceReadOnly> capacityReservations
                        = reader.readArray(reader1 -> SubResourceReadOnly.fromJson(reader1));
                    deserializedCapacityReservationGroupProperties.capacityReservations = capacityReservations;
                } else if ("virtualMachinesAssociated".equals(fieldName)) {
                    List<SubResourceReadOnly> virtualMachinesAssociated
                        = reader.readArray(reader1 -> SubResourceReadOnly.fromJson(reader1));
                    deserializedCapacityReservationGroupProperties.virtualMachinesAssociated
                        = virtualMachinesAssociated;
                } else if ("instanceView".equals(fieldName)) {
                    deserializedCapacityReservationGroupProperties.instanceView
                        = CapacityReservationGroupInstanceView.fromJson(reader);
                } else if ("sharingProfile".equals(fieldName)) {
                    deserializedCapacityReservationGroupProperties.sharingProfile
                        = ResourceSharingProfile.fromJson(reader);
                } else if ("reservationType".equals(fieldName)) {
                    deserializedCapacityReservationGroupProperties.reservationType
                        = ReservationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCapacityReservationGroupProperties;
        });
    }
}
