// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CommunityGalleryMetadata;
import java.io.IOException;
import java.util.Map;

/**
 * Describes the properties of a community gallery.
 */
@Fluent
public final class CommunityGalleryProperties implements JsonSerializable<CommunityGalleryProperties> {
    /*
     * The disclaimer for a community gallery resource.
     */
    private String disclaimer;

    /*
     * The artifact tags of a community gallery resource.
     */
    private Map<String, String> artifactTags;

    /*
     * The metadata of community gallery.
     */
    private CommunityGalleryMetadata communityMetadata;

    /**
     * Creates an instance of CommunityGalleryProperties class.
     */
    public CommunityGalleryProperties() {
    }

    /**
     * Get the disclaimer property: The disclaimer for a community gallery resource.
     * 
     * @return the disclaimer value.
     */
    public String disclaimer() {
        return this.disclaimer;
    }

    /**
     * Set the disclaimer property: The disclaimer for a community gallery resource.
     * 
     * @param disclaimer the disclaimer value to set.
     * @return the CommunityGalleryProperties object itself.
     */
    public CommunityGalleryProperties withDisclaimer(String disclaimer) {
        this.disclaimer = disclaimer;
        return this;
    }

    /**
     * Get the artifactTags property: The artifact tags of a community gallery resource.
     * 
     * @return the artifactTags value.
     */
    public Map<String, String> artifactTags() {
        return this.artifactTags;
    }

    /**
     * Set the artifactTags property: The artifact tags of a community gallery resource.
     * 
     * @param artifactTags the artifactTags value to set.
     * @return the CommunityGalleryProperties object itself.
     */
    public CommunityGalleryProperties withArtifactTags(Map<String, String> artifactTags) {
        this.artifactTags = artifactTags;
        return this;
    }

    /**
     * Get the communityMetadata property: The metadata of community gallery.
     * 
     * @return the communityMetadata value.
     */
    public CommunityGalleryMetadata communityMetadata() {
        return this.communityMetadata;
    }

    /**
     * Set the communityMetadata property: The metadata of community gallery.
     * 
     * @param communityMetadata the communityMetadata value to set.
     * @return the CommunityGalleryProperties object itself.
     */
    public CommunityGalleryProperties withCommunityMetadata(CommunityGalleryMetadata communityMetadata) {
        this.communityMetadata = communityMetadata;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (communityMetadata() != null) {
            communityMetadata().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("disclaimer", this.disclaimer);
        jsonWriter.writeMapField("artifactTags", this.artifactTags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("communityMetadata", this.communityMetadata);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CommunityGalleryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CommunityGalleryProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CommunityGalleryProperties.
     */
    public static CommunityGalleryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CommunityGalleryProperties deserializedCommunityGalleryProperties = new CommunityGalleryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("disclaimer".equals(fieldName)) {
                    deserializedCommunityGalleryProperties.disclaimer = reader.getString();
                } else if ("artifactTags".equals(fieldName)) {
                    Map<String, String> artifactTags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCommunityGalleryProperties.artifactTags = artifactTags;
                } else if ("communityMetadata".equals(fieldName)) {
                    deserializedCommunityGalleryProperties.communityMetadata
                        = CommunityGalleryMetadata.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCommunityGalleryProperties;
        });
    }
}
