// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import java.io.IOException;

/**
 * Describes a network interface reference properties.
 */
@Fluent
public final class NetworkInterfaceReferenceProperties
    implements JsonSerializable<NetworkInterfaceReferenceProperties> {
    /*
     * Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    private Boolean primary;

    /*
     * Specify what happens to the network interface when the VM is deleted
     */
    private DeleteOptions deleteOption;

    /**
     * Creates an instance of NetworkInterfaceReferenceProperties class.
     */
    public NetworkInterfaceReferenceProperties() {
    }

    /**
     * Get the primary property: Specifies the primary network interface in case the virtual machine has more than 1
     * network interface.
     * 
     * @return the primary value.
     */
    public Boolean primary() {
        return this.primary;
    }

    /**
     * Set the primary property: Specifies the primary network interface in case the virtual machine has more than 1
     * network interface.
     * 
     * @param primary the primary value to set.
     * @return the NetworkInterfaceReferenceProperties object itself.
     */
    public NetworkInterfaceReferenceProperties withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    /**
     * Get the deleteOption property: Specify what happens to the network interface when the VM is deleted.
     * 
     * @return the deleteOption value.
     */
    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    /**
     * Set the deleteOption property: Specify what happens to the network interface when the VM is deleted.
     * 
     * @param deleteOption the deleteOption value to set.
     * @return the NetworkInterfaceReferenceProperties object itself.
     */
    public NetworkInterfaceReferenceProperties withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("primary", this.primary);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkInterfaceReferenceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkInterfaceReferenceProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkInterfaceReferenceProperties.
     */
    public static NetworkInterfaceReferenceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkInterfaceReferenceProperties deserializedNetworkInterfaceReferenceProperties
                = new NetworkInterfaceReferenceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("primary".equals(fieldName)) {
                    deserializedNetworkInterfaceReferenceProperties.primary
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("deleteOption".equals(fieldName)) {
                    deserializedNetworkInterfaceReferenceProperties.deleteOption
                        = DeleteOptions.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkInterfaceReferenceProperties;
        });
    }
}
