// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.OSVersionProperties;
import java.io.IOException;

/**
 * Describes a cloud service OS version.
 */
@Fluent
public final class OSVersionInner implements JsonSerializable<OSVersionInner> {
    /*
     * Resource Id.
     */
    private String id;

    /*
     * Resource name.
     */
    private String name;

    /*
     * Resource type.
     */
    private String type;

    /*
     * Resource location.
     */
    private String location;

    /*
     * OS version properties.
     */
    private OSVersionProperties properties;

    /**
     * Creates an instance of OSVersionInner class.
     */
    public OSVersionInner() {
    }

    /**
     * Get the id property: Resource Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: Resource name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the location property: Resource location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the properties property: OS version properties.
     * 
     * @return the properties value.
     */
    public OSVersionProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: OS version properties.
     * 
     * @param properties the properties value to set.
     * @return the OSVersionInner object itself.
     */
    public OSVersionInner withProperties(OSVersionProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OSVersionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OSVersionInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OSVersionInner.
     */
    public static OSVersionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OSVersionInner deserializedOSVersionInner = new OSVersionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedOSVersionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedOSVersionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedOSVersionInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedOSVersionInner.location = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedOSVersionInner.properties = OSVersionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOSVersionInner;
        });
    }
}
