// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ResourceSkuCapabilities;
import com.azure.resourcemanager.compute.models.ResourceSkuCapacity;
import com.azure.resourcemanager.compute.models.ResourceSkuCosts;
import com.azure.resourcemanager.compute.models.ResourceSkuLocationInfo;
import com.azure.resourcemanager.compute.models.ResourceSkuRestrictions;
import java.io.IOException;
import java.util.List;

/**
 * Describes an available Compute SKU.
 */
@Immutable
public final class ResourceSkuInner implements JsonSerializable<ResourceSkuInner> {
    /*
     * The type of resource the SKU applies to.
     */
    private String resourceType;

    /*
     * The name of SKU.
     */
    private String name;

    /*
     * Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br
     * /><br /> **Basic**
     */
    private String tier;

    /*
     * The Size of the SKU.
     */
    private String size;

    /*
     * The Family of this particular SKU.
     */
    private String family;

    /*
     * The Kind of resources that are supported in this SKU.
     */
    private String kind;

    /*
     * Specifies the number of virtual machines in the scale set.
     */
    private ResourceSkuCapacity capacity;

    /*
     * The set of locations that the SKU is available.
     */
    private List<String> locations;

    /*
     * A list of locations and availability zones in those locations where the SKU is available.
     */
    private List<ResourceSkuLocationInfo> locationInfo;

    /*
     * The api versions that support this SKU.
     */
    private List<String> apiVersions;

    /*
     * Metadata for retrieving price info.
     */
    private List<ResourceSkuCosts> costs;

    /*
     * A name value pair to describe the capability.
     */
    private List<ResourceSkuCapabilities> capabilities;

    /*
     * The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
     */
    private List<ResourceSkuRestrictions> restrictions;

    /**
     * Creates an instance of ResourceSkuInner class.
     */
    public ResourceSkuInner() {
    }

    /**
     * Get the resourceType property: The type of resource the SKU applies to.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Get the name property: The name of SKU.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the tier property: Specifies the tier of virtual machines in a scale set.&lt;br /&gt;&lt;br /&gt; Possible
     * Values:&lt;br /&gt;&lt;br /&gt; **Standard**&lt;br /&gt;&lt;br /&gt; **Basic**.
     * 
     * @return the tier value.
     */
    public String tier() {
        return this.tier;
    }

    /**
     * Get the size property: The Size of the SKU.
     * 
     * @return the size value.
     */
    public String size() {
        return this.size;
    }

    /**
     * Get the family property: The Family of this particular SKU.
     * 
     * @return the family value.
     */
    public String family() {
        return this.family;
    }

    /**
     * Get the kind property: The Kind of resources that are supported in this SKU.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the capacity property: Specifies the number of virtual machines in the scale set.
     * 
     * @return the capacity value.
     */
    public ResourceSkuCapacity capacity() {
        return this.capacity;
    }

    /**
     * Get the locations property: The set of locations that the SKU is available.
     * 
     * @return the locations value.
     */
    public List<String> locations() {
        return this.locations;
    }

    /**
     * Get the locationInfo property: A list of locations and availability zones in those locations where the SKU is
     * available.
     * 
     * @return the locationInfo value.
     */
    public List<ResourceSkuLocationInfo> locationInfo() {
        return this.locationInfo;
    }

    /**
     * Get the apiVersions property: The api versions that support this SKU.
     * 
     * @return the apiVersions value.
     */
    public List<String> apiVersions() {
        return this.apiVersions;
    }

    /**
     * Get the costs property: Metadata for retrieving price info.
     * 
     * @return the costs value.
     */
    public List<ResourceSkuCosts> costs() {
        return this.costs;
    }

    /**
     * Get the capabilities property: A name value pair to describe the capability.
     * 
     * @return the capabilities value.
     */
    public List<ResourceSkuCapabilities> capabilities() {
        return this.capabilities;
    }

    /**
     * Get the restrictions property: The restrictions because of which SKU cannot be used. This is empty if there are
     * no restrictions.
     * 
     * @return the restrictions value.
     */
    public List<ResourceSkuRestrictions> restrictions() {
        return this.restrictions;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capacity() != null) {
            capacity().validate();
        }
        if (locationInfo() != null) {
            locationInfo().forEach(e -> e.validate());
        }
        if (costs() != null) {
            costs().forEach(e -> e.validate());
        }
        if (capabilities() != null) {
            capabilities().forEach(e -> e.validate());
        }
        if (restrictions() != null) {
            restrictions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceSkuInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceSkuInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceSkuInner.
     */
    public static ResourceSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSkuInner deserializedResourceSkuInner = new ResourceSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceType".equals(fieldName)) {
                    deserializedResourceSkuInner.resourceType = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedResourceSkuInner.name = reader.getString();
                } else if ("tier".equals(fieldName)) {
                    deserializedResourceSkuInner.tier = reader.getString();
                } else if ("size".equals(fieldName)) {
                    deserializedResourceSkuInner.size = reader.getString();
                } else if ("family".equals(fieldName)) {
                    deserializedResourceSkuInner.family = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedResourceSkuInner.kind = reader.getString();
                } else if ("capacity".equals(fieldName)) {
                    deserializedResourceSkuInner.capacity = ResourceSkuCapacity.fromJson(reader);
                } else if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceSkuInner.locations = locations;
                } else if ("locationInfo".equals(fieldName)) {
                    List<ResourceSkuLocationInfo> locationInfo
                        = reader.readArray(reader1 -> ResourceSkuLocationInfo.fromJson(reader1));
                    deserializedResourceSkuInner.locationInfo = locationInfo;
                } else if ("apiVersions".equals(fieldName)) {
                    List<String> apiVersions = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceSkuInner.apiVersions = apiVersions;
                } else if ("costs".equals(fieldName)) {
                    List<ResourceSkuCosts> costs = reader.readArray(reader1 -> ResourceSkuCosts.fromJson(reader1));
                    deserializedResourceSkuInner.costs = costs;
                } else if ("capabilities".equals(fieldName)) {
                    List<ResourceSkuCapabilities> capabilities
                        = reader.readArray(reader1 -> ResourceSkuCapabilities.fromJson(reader1));
                    deserializedResourceSkuInner.capabilities = capabilities;
                } else if ("restrictions".equals(fieldName)) {
                    List<ResourceSkuRestrictions> restrictions
                        = reader.readArray(reader1 -> ResourceSkuRestrictions.fromJson(reader1));
                    deserializedResourceSkuInner.restrictions = restrictions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceSkuInner;
        });
    }
}
