// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the storage account type to be used to store the image. This property is not updatable.
 */
public final class EdgeZoneStorageAccountType extends ExpandableStringEnum<EdgeZoneStorageAccountType> {
    /**
     * Static value Standard_LRS for EdgeZoneStorageAccountType.
     */
    public static final EdgeZoneStorageAccountType STANDARD_LRS = fromString("Standard_LRS");

    /**
     * Static value Standard_ZRS for EdgeZoneStorageAccountType.
     */
    public static final EdgeZoneStorageAccountType STANDARD_ZRS = fromString("Standard_ZRS");

    /**
     * Static value StandardSSD_LRS for EdgeZoneStorageAccountType.
     */
    public static final EdgeZoneStorageAccountType STANDARD_SSD_LRS = fromString("StandardSSD_LRS");

    /**
     * Static value Premium_LRS for EdgeZoneStorageAccountType.
     */
    public static final EdgeZoneStorageAccountType PREMIUM_LRS = fromString("Premium_LRS");

    /**
     * Creates a new instance of EdgeZoneStorageAccountType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public EdgeZoneStorageAccountType() {
    }

    /**
     * Creates or finds a EdgeZoneStorageAccountType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding EdgeZoneStorageAccountType.
     */
    public static EdgeZoneStorageAccountType fromString(String name) {
        return fromString(name, EdgeZoneStorageAccountType.class);
    }

    /**
     * Gets known EdgeZoneStorageAccountType values.
     * 
     * @return known EdgeZoneStorageAccountType values.
     */
    public static Collection<EdgeZoneStorageAccountType> values() {
        return values(EdgeZoneStorageAccountType.class);
    }
}
