// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the properties of a gallery inVMAccessControlProfile.
 */
@Fluent
public final class GalleryInVMAccessControlProfileProperties extends GalleryResourceProfilePropertiesBase {
    /*
     * The description of this gallery inVMAccessControlProfile resources. This property is updatable.
     */
    private String description;

    /*
     * This property allows you to specify the OS type of the VMs/VMSS for which this profile can be used against.
     * Possible values are: 'Windows' or 'Linux'
     */
    private OperatingSystemTypes osType;

    /*
     * This property allows you to specify the Endpoint type for which this profile is defining the access control for.
     * Possible values are: 'WireServer' or 'IMDS'
     */
    private EndpointTypes applicableHostEndpoint;

    /*
     * The provisioning state, which only appears in the response.
     */
    private GalleryProvisioningState provisioningState;

    /**
     * Creates an instance of GalleryInVMAccessControlProfileProperties class.
     */
    public GalleryInVMAccessControlProfileProperties() {
    }

    /**
     * Get the description property: The description of this gallery inVMAccessControlProfile resources. This property
     * is updatable.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of this gallery inVMAccessControlProfile resources. This property
     * is updatable.
     * 
     * @param description the description value to set.
     * @return the GalleryInVMAccessControlProfileProperties object itself.
     */
    public GalleryInVMAccessControlProfileProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the osType property: This property allows you to specify the OS type of the VMs/VMSS for which this profile
     * can be used against. Possible values are: 'Windows' or 'Linux'.
     * 
     * @return the osType value.
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Set the osType property: This property allows you to specify the OS type of the VMs/VMSS for which this profile
     * can be used against. Possible values are: 'Windows' or 'Linux'.
     * 
     * @param osType the osType value to set.
     * @return the GalleryInVMAccessControlProfileProperties object itself.
     */
    public GalleryInVMAccessControlProfileProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the applicableHostEndpoint property: This property allows you to specify the Endpoint type for which this
     * profile is defining the access control for. Possible values are: 'WireServer' or 'IMDS'.
     * 
     * @return the applicableHostEndpoint value.
     */
    public EndpointTypes applicableHostEndpoint() {
        return this.applicableHostEndpoint;
    }

    /**
     * Set the applicableHostEndpoint property: This property allows you to specify the Endpoint type for which this
     * profile is defining the access control for. Possible values are: 'WireServer' or 'IMDS'.
     * 
     * @param applicableHostEndpoint the applicableHostEndpoint value to set.
     * @return the GalleryInVMAccessControlProfileProperties object itself.
     */
    public GalleryInVMAccessControlProfileProperties withApplicableHostEndpoint(EndpointTypes applicableHostEndpoint) {
        this.applicableHostEndpoint = applicableHostEndpoint;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    @Override
    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (osType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property osType in model GalleryInVMAccessControlProfileProperties"));
        }
        if (applicableHostEndpoint() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property applicableHostEndpoint in model GalleryInVMAccessControlProfileProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryInVMAccessControlProfileProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("applicableHostEndpoint",
            this.applicableHostEndpoint == null ? null : this.applicableHostEndpoint.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryInVMAccessControlProfileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryInVMAccessControlProfileProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryInVMAccessControlProfileProperties.
     */
    public static GalleryInVMAccessControlProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryInVMAccessControlProfileProperties deserializedGalleryInVMAccessControlProfileProperties
                = new GalleryInVMAccessControlProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileProperties.provisioningState
                        = GalleryProvisioningState.fromString(reader.getString());
                } else if ("osType".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileProperties.osType
                        = OperatingSystemTypes.fromString(reader.getString());
                } else if ("applicableHostEndpoint".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileProperties.applicableHostEndpoint
                        = EndpointTypes.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileProperties.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryInVMAccessControlProfileProperties;
        });
    }
}
