// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will start to audit or
 * monitor but not enforce access control over requests to host endpoints in Audit mode, while in Enforce mode it will
 * enforce access control. The default value is Enforce mode.
 */
public final class Mode extends ExpandableStringEnum<Mode> {
    /**
     * Static value Audit for Mode.
     */
    public static final Mode AUDIT = fromString("Audit");

    /**
     * Static value Enforce for Mode.
     */
    public static final Mode ENFORCE = fromString("Enforce");

    /**
     * Creates a new instance of Mode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Mode() {
    }

    /**
     * Creates or finds a Mode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding Mode.
     */
    public static Mode fromString(String name) {
        return fromString(name, Mode.class);
    }

    /**
     * Gets known Mode values.
     * 
     * @return known Mode values.
     */
    public static Collection<Mode> values() {
        return values(Mode.class);
    }
}
