// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The latest operation status of the service.
 */
public final class OrchestrationServiceOperationStatus
    extends ExpandableStringEnum<OrchestrationServiceOperationStatus> {
    /**
     * Static value InProgress for OrchestrationServiceOperationStatus.
     */
    public static final OrchestrationServiceOperationStatus IN_PROGRESS = fromString("InProgress");

    /**
     * Static value Completed for OrchestrationServiceOperationStatus.
     */
    public static final OrchestrationServiceOperationStatus COMPLETED = fromString("Completed");

    /**
     * Creates a new instance of OrchestrationServiceOperationStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public OrchestrationServiceOperationStatus() {
    }

    /**
     * Creates or finds a OrchestrationServiceOperationStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding OrchestrationServiceOperationStatus.
     */
    public static OrchestrationServiceOperationStatus fromString(String name) {
        return fromString(name, OrchestrationServiceOperationStatus.class);
    }

    /**
     * Gets known OrchestrationServiceOperationStatus values.
     * 
     * @return known OrchestrationServiceOperationStatus values.
     */
    public static Collection<OrchestrationServiceOperationStatus> values() {
        return values(OrchestrationServiceOperationStatus.class);
    }
}
