// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Virtual Machine operation response.
 */
@Fluent
public final class VirtualMachineListResult implements JsonSerializable<VirtualMachineListResult> {
    /*
     * The list of virtual machines.
     */
    private List<VirtualMachineInner> value;

    /*
     * The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch the next page of Virtual Machines.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualMachineListResult class.
     */
    public VirtualMachineListResult() {
    }

    /**
     * Get the value property: The list of virtual machines.
     * 
     * @return the value value.
     */
    public List<VirtualMachineInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of virtual machines.
     * 
     * @param value the value value to set.
     * @return the VirtualMachineListResult object itself.
     */
    public VirtualMachineListResult withValue(List<VirtualMachineInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch the next
     * page of Virtual Machines.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch the next
     * page of Virtual Machines.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VirtualMachineListResult object itself.
     */
    public VirtualMachineListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model VirtualMachineListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualMachineListResult.
     */
    public static VirtualMachineListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineListResult deserializedVirtualMachineListResult = new VirtualMachineListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualMachineInner> value
                        = reader.readArray(reader1 -> VirtualMachineInner.fromJson(reader1));
                    deserializedVirtualMachineListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineListResult;
        });
    }
}
