// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.
 */
@Fluent
public final class VirtualMachineScaleSetUpdatePublicIpAddressConfiguration
    implements JsonSerializable<VirtualMachineScaleSetUpdatePublicIpAddressConfiguration> {
    /*
     * The publicIP address configuration name.
     */
    private String name;

    /*
     * Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration
     */
    private VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties innerProperties;

    /*
     * Resource tags applied to the publicIP address created by this PublicIPAddressConfiguration
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of VirtualMachineScaleSetUpdatePublicIpAddressConfiguration class.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfiguration() {
    }

    /**
     * Get the name property: The publicIP address configuration name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The publicIP address configuration name.
     * 
     * @param name the name value to set.
     * @return the VirtualMachineScaleSetUpdatePublicIpAddressConfiguration object itself.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the innerProperties property: Describes a virtual machines scale set IP Configuration's PublicIPAddress
     * configuration.
     * 
     * @return the innerProperties value.
     */
    private VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the tags property: Resource tags applied to the publicIP address created by this
     * PublicIPAddressConfiguration.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags applied to the publicIP address created by this
     * PublicIPAddressConfiguration.
     * 
     * @param tags the tags value to set.
     * @return the VirtualMachineScaleSetUpdatePublicIpAddressConfiguration object itself.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfiguration withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the idleTimeoutInMinutes property: The idle timeout of the public IP address.
     * 
     * @return the idleTimeoutInMinutes value.
     */
    public Integer idleTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().idleTimeoutInMinutes();
    }

    /**
     * Set the idleTimeoutInMinutes property: The idle timeout of the public IP address.
     * 
     * @param idleTimeoutInMinutes the idleTimeoutInMinutes value to set.
     * @return the VirtualMachineScaleSetUpdatePublicIpAddressConfiguration object itself.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfiguration
        withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withIdleTimeoutInMinutes(idleTimeoutInMinutes);
        return this;
    }

    /**
     * Get the dnsSettings property: The dns settings to be applied on the publicIP addresses .
     * 
     * @return the dnsSettings value.
     */
    public VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSettings();
    }

    /**
     * Set the dnsSettings property: The dns settings to be applied on the publicIP addresses .
     * 
     * @param dnsSettings the dnsSettings value to set.
     * @return the VirtualMachineScaleSetUpdatePublicIpAddressConfiguration object itself.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfiguration
        withDnsSettings(VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withDnsSettings(dnsSettings);
        return this;
    }

    /**
     * Get the publicIpPrefix property: The PublicIPPrefix from which to allocate publicIP addresses.
     * 
     * @return the publicIpPrefix value.
     */
    public SubResource publicIpPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpPrefix();
    }

    /**
     * Set the publicIpPrefix property: The PublicIPPrefix from which to allocate publicIP addresses.
     * 
     * @param publicIpPrefix the publicIpPrefix value to set.
     * @return the VirtualMachineScaleSetUpdatePublicIpAddressConfiguration object itself.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfiguration withPublicIpPrefix(SubResource publicIpPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withPublicIpPrefix(publicIpPrefix);
        return this;
    }

    /**
     * Get the deleteOption property: Specify what happens to the public IP when the VM is deleted.
     * 
     * @return the deleteOption value.
     */
    public DeleteOptions deleteOption() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteOption();
    }

    /**
     * Set the deleteOption property: Specify what happens to the public IP when the VM is deleted.
     * 
     * @param deleteOption the deleteOption value to set.
     * @return the VirtualMachineScaleSetUpdatePublicIpAddressConfiguration object itself.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfiguration withDeleteOption(DeleteOptions deleteOption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties();
        }
        this.innerProperties().withDeleteOption(deleteOption);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetUpdatePublicIpAddressConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetUpdatePublicIpAddressConfiguration if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * VirtualMachineScaleSetUpdatePublicIpAddressConfiguration.
     */
    public static VirtualMachineScaleSetUpdatePublicIpAddressConfiguration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdatePublicIpAddressConfiguration deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfiguration
                = new VirtualMachineScaleSetUpdatePublicIpAddressConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfiguration.name = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfiguration.innerProperties
                        = VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfiguration.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfiguration;
        });
    }
}
