// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes a virtual machine scale set storage profile.
 */
@Fluent
public final class VirtualMachineScaleSetUpdateStorageProfile
    implements JsonSerializable<VirtualMachineScaleSetUpdateStorageProfile> {
    /*
     * The image reference.
     */
    private ImageReference imageReference;

    /*
     * The OS disk.
     */
    private VirtualMachineScaleSetUpdateOSDisk osDisk;

    /*
     * The data disks.
     */
    private List<VirtualMachineScaleSetDataDisk> dataDisks;

    /*
     * Specifies the disk controller type configured for the virtual machines in the scale set. **Note:** You need to
     * deallocate the virtual machines in the scale set before updating its disk controller type based on the upgrade
     * mode configured for the scale set. Minimum api-version: 2022-08-01
     */
    private DiskControllerTypes diskControllerType;

    /**
     * Creates an instance of VirtualMachineScaleSetUpdateStorageProfile class.
     */
    public VirtualMachineScaleSetUpdateStorageProfile() {
    }

    /**
     * Get the imageReference property: The image reference.
     * 
     * @return the imageReference value.
     */
    public ImageReference imageReference() {
        return this.imageReference;
    }

    /**
     * Set the imageReference property: The image reference.
     * 
     * @param imageReference the imageReference value to set.
     * @return the VirtualMachineScaleSetUpdateStorageProfile object itself.
     */
    public VirtualMachineScaleSetUpdateStorageProfile withImageReference(ImageReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    /**
     * Get the osDisk property: The OS disk.
     * 
     * @return the osDisk value.
     */
    public VirtualMachineScaleSetUpdateOSDisk osDisk() {
        return this.osDisk;
    }

    /**
     * Set the osDisk property: The OS disk.
     * 
     * @param osDisk the osDisk value to set.
     * @return the VirtualMachineScaleSetUpdateStorageProfile object itself.
     */
    public VirtualMachineScaleSetUpdateStorageProfile withOsDisk(VirtualMachineScaleSetUpdateOSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    /**
     * Get the dataDisks property: The data disks.
     * 
     * @return the dataDisks value.
     */
    public List<VirtualMachineScaleSetDataDisk> dataDisks() {
        return this.dataDisks;
    }

    /**
     * Set the dataDisks property: The data disks.
     * 
     * @param dataDisks the dataDisks value to set.
     * @return the VirtualMachineScaleSetUpdateStorageProfile object itself.
     */
    public VirtualMachineScaleSetUpdateStorageProfile withDataDisks(List<VirtualMachineScaleSetDataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    /**
     * Get the diskControllerType property: Specifies the disk controller type configured for the virtual machines in
     * the scale set. **Note:** You need to deallocate the virtual machines in the scale set before updating its disk
     * controller type based on the upgrade mode configured for the scale set. Minimum api-version: 2022-08-01.
     * 
     * @return the diskControllerType value.
     */
    public DiskControllerTypes diskControllerType() {
        return this.diskControllerType;
    }

    /**
     * Set the diskControllerType property: Specifies the disk controller type configured for the virtual machines in
     * the scale set. **Note:** You need to deallocate the virtual machines in the scale set before updating its disk
     * controller type based on the upgrade mode configured for the scale set. Minimum api-version: 2022-08-01.
     * 
     * @param diskControllerType the diskControllerType value to set.
     * @return the VirtualMachineScaleSetUpdateStorageProfile object itself.
     */
    public VirtualMachineScaleSetUpdateStorageProfile withDiskControllerType(DiskControllerTypes diskControllerType) {
        this.diskControllerType = diskControllerType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (imageReference() != null) {
            imageReference().validate();
        }
        if (osDisk() != null) {
            osDisk().validate();
        }
        if (dataDisks() != null) {
            dataDisks().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("imageReference", this.imageReference);
        jsonWriter.writeJsonField("osDisk", this.osDisk);
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("diskControllerType",
            this.diskControllerType == null ? null : this.diskControllerType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetUpdateStorageProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetUpdateStorageProfile if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetUpdateStorageProfile.
     */
    public static VirtualMachineScaleSetUpdateStorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdateStorageProfile deserializedVirtualMachineScaleSetUpdateStorageProfile
                = new VirtualMachineScaleSetUpdateStorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("imageReference".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateStorageProfile.imageReference
                        = ImageReference.fromJson(reader);
                } else if ("osDisk".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateStorageProfile.osDisk
                        = VirtualMachineScaleSetUpdateOSDisk.fromJson(reader);
                } else if ("dataDisks".equals(fieldName)) {
                    List<VirtualMachineScaleSetDataDisk> dataDisks
                        = reader.readArray(reader1 -> VirtualMachineScaleSetDataDisk.fromJson(reader1));
                    deserializedVirtualMachineScaleSetUpdateStorageProfile.dataDisks = dataDisks;
                } else if ("diskControllerType".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateStorageProfile.diskControllerType
                        = DiskControllerTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetUpdateStorageProfile;
        });
    }
}
