/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.ProximityPlacementGroupProperties;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupPropertiesIntent;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupType;
import com.azure.resourcemanager.compute.models.SubResourceWithColocationStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ProximityPlacementGroupInner
extends Resource {
    private ProximityPlacementGroupProperties innerProperties;
    private List<String> zones;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ProximityPlacementGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public ProximityPlacementGroupInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ProximityPlacementGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProximityPlacementGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProximityPlacementGroupType proximityPlacementGroupType() {
        return this.innerProperties() == null ? null : this.innerProperties().proximityPlacementGroupType();
    }

    public ProximityPlacementGroupInner withProximityPlacementGroupType(ProximityPlacementGroupType proximityPlacementGroupType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProximityPlacementGroupProperties();
        }
        this.innerProperties().withProximityPlacementGroupType(proximityPlacementGroupType);
        return this;
    }

    public List<SubResourceWithColocationStatus> virtualMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachines();
    }

    public List<SubResourceWithColocationStatus> virtualMachineScaleSets() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachineScaleSets();
    }

    public List<SubResourceWithColocationStatus> availabilitySets() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilitySets();
    }

    public InstanceViewStatus colocationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().colocationStatus();
    }

    public ProximityPlacementGroupInner withColocationStatus(InstanceViewStatus colocationStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProximityPlacementGroupProperties();
        }
        this.innerProperties().withColocationStatus(colocationStatus);
        return this;
    }

    public ProximityPlacementGroupPropertiesIntent intent() {
        return this.innerProperties() == null ? null : this.innerProperties().intent();
    }

    public ProximityPlacementGroupInner withIntent(ProximityPlacementGroupPropertiesIntent intent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProximityPlacementGroupProperties();
        }
        this.innerProperties().withIntent(intent);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ProximityPlacementGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProximityPlacementGroupInner)((Object)jsonReader.readObject(reader -> {
            ProximityPlacementGroupInner deserializedProximityPlacementGroupInner = new ProximityPlacementGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProximityPlacementGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProximityPlacementGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedProximityPlacementGroupInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedProximityPlacementGroupInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedProximityPlacementGroupInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProximityPlacementGroupInner.innerProperties = ProximityPlacementGroupProperties.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedProximityPlacementGroupInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedProximityPlacementGroupInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProximityPlacementGroupInner;
        }));
    }
}

